/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.util;

import com.logicaldoc.installer.util.Base64;
import com.logicalobjects.jlicense.license.SystemInfo;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;

public class LicenseRequest
extends Properties {
    private static final long serialVersionUID = 1L;

    public LicenseRequest() {
        this.put("os.name", this.valOrEmpty(System.getProperty("os.name")));
        try {
            this.put("network.ip", this.valOrEmpty(InetAddress.getLocalHost().getHostAddress()));
        }
        catch (UnknownHostException e2) {
            e2.printStackTrace();
        }
        this.put("network.mac", this.valOrEmpty(SystemInfo.getMAC()));
        this.put("computerName", this.valOrEmpty(SystemInfo.getComputerName()));
        this.put("mb.serial", this.valOrEmpty(SystemInfo.getBaseboardSerialNumber()));
        this.put("cpu.id", this.valOrEmpty(SystemInfo.getCpuID()));
        this.put("system.serial", this.valOrEmpty(SystemInfo.getComputerSerialNumber()));
        try {
            this.put("sid", this.valOrEmpty(SystemInfo.getSID()));
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
    }

    public LicenseRequest(String request) throws IOException {
        this.load(request);
    }

    private String valOrEmpty(String val) {
        if (val != null) {
            return val;
        }
        return "";
    }

    public void load(String request) throws IOException {
        this.clear();
        String decodedRequest = Base64.decode(request);
        this.load(new StringReader(decodedRequest));
    }

    public String store() throws IOException {
        StringWriter writer = new StringWriter();
        this.store(writer, "");
        writer.flush();
        writer.close();
        return Base64.encode(writer.getBuffer().toString());
    }

    public static void main(String[] args) throws IOException {
        LicenseRequest req = new LicenseRequest();
        String content = req.store();
        System.out.println(content);
    }
}

