/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.util;

import com.logicaldoc.installer.update.WindowsReqistry;
import com.logicaldoc.installer.util.Log;

public class JavaUtil {
    public static void main(String[] args) {
        System.out.println("JDK: " + JavaUtil.getJDK());
        System.out.println("JRE: " + JavaUtil.getJRE());
    }

    public static String getJDK() {
        String javaHome = null;
        String cv = WindowsReqistry.read("HKEY_LOCAL_MACHINE\\SOFTWARE\\JavaSoft\\JDK", "CurrentVersion");
        if (cv != null) {
            Log.info("Java current version: " + cv, null);
            javaHome = WindowsReqistry.read("HKEY_LOCAL_MACHINE\\SOFTWARE\\JavaSoft\\JDK\\" + cv, "JavaHome");
            if (javaHome != null) {
                return javaHome;
            }
        }
        if ((cv = WindowsReqistry.read("HKEY_LOCAL_MACHINE\\SOFTWARE\\JavaSoft\\Java Development Kit", "CurrentVersion")) != null) {
            Log.info("Java current version: " + cv, null);
            javaHome = WindowsReqistry.read("HKEY_LOCAL_MACHINE\\SOFTWARE\\JavaSoft\\Java Development Kit\\" + cv, "JavaHome");
            if (javaHome != null) {
                return javaHome;
            }
        }
        Log.info("Unable to find a JDK in the registry, check the filesystem", null);
        return javaHome;
    }

    public static String getJRE() {
        String javaHome = null;
        String cv = WindowsReqistry.read("HKEY_LOCAL_MACHINE\\SOFTWARE\\JavaSoft\\JDK", "CurrentVersion");
        if (cv != null) {
            Log.info("Java current version: " + cv, null);
            javaHome = WindowsReqistry.read("HKEY_LOCAL_MACHINE\\SOFTWARE\\JavaSoft\\JDK\\" + cv, "JavaHome");
            if (javaHome != null) {
                return javaHome;
            }
        }
        if ((cv = WindowsReqistry.read("HKEY_LOCAL_MACHINE\\SOFTWARE\\JavaSoft\\Java Runtime Environment", "CurrentVersion")) != null) {
            Log.info("Java current version: " + cv, null);
            javaHome = WindowsReqistry.read("HKEY_LOCAL_MACHINE\\SOFTWARE\\JavaSoft\\Java Runtime Environment\\" + cv, "JavaHome");
            if (javaHome != null) {
                return javaHome;
            }
        }
        Log.info("Unable to find a JRE in the registry, check the filesystem", null);
        return javaHome;
    }
}

