/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileUtil {
    public static void copyFile(File in, File out) throws Exception {
        FileInputStream fis = new FileInputStream(in);
        FileOutputStream fos = new FileOutputStream(out);
        try {
            byte[] buf = new byte[1024];
            int i2 = 0;
            while ((i2 = fis.read(buf)) != -1) {
                fos.write(buf, 0, i2);
            }
        }
        catch (Exception e2) {
            throw e2;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsString(String filePath) throws IOException {
        byte[] buffer = new byte[(int)new File(filePath).length()];
        BufferedInputStream f2 = null;
        try {
            f2 = new BufferedInputStream(new FileInputStream(filePath));
            f2.read(buffer);
        }
        finally {
            if (f2 != null) {
                try {
                    f2.close();
                }
                catch (IOException iOException) {}
            }
        }
        return new String(buffer);
    }

    public static boolean is64bit() {
        boolean is64bit = System.getProperty("os.arch").indexOf("64") != -1;
        return is64bit;
    }

    public static boolean isWindows() {
        boolean windows = System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
        return windows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyResource(String resourceName, File out) throws IOException {
        InputStream is = null;
        OutputStream os = null;
        try {
            int b2;
            try {
                is = new BufferedInputStream(FileUtil.class.getResource(resourceName).openStream());
            }
            catch (Exception e2) {
                is = new BufferedInputStream(Thread.currentThread().getContextClassLoader().getResource(resourceName).openStream());
            }
            os = new BufferedOutputStream(new FileOutputStream(out));
            while ((b2 = is.read()) != -1) {
                os.write(b2);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    public static void writeFile(String text, String filepath) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filepath));){
            bos.write(text.getBytes("UTF-8"));
            bos.flush();
        }
    }

    public static void writeToFile(InputStream is, File file) throws IOException {
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
            int c2;
            while ((c2 = is.read()) != -1) {
                out.writeByte(c2);
            }
            is.close();
        }
    }
}

