/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.util;

import com.logicaldoc.installer.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Exec {
    public static int exec(List<String> command) throws IOException {
        return Exec.exec(command, null, null, -1);
    }

    public static int exec(final List<String> command, Map<String, String> env, File dir, int timeout) throws IOException {
        int exit = 0;
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.redirectErrorStream(true);
        if (env != null) {
            for (String name : env.keySet()) {
                builder.environment().put(name, env.get(name).toString());
            }
        }
        if (dir != null) {
            builder.directory(dir);
        }
        final Process process = builder.start();
        Timer t2 = null;
        if (timeout > 0) {
            t2 = new Timer(true);
            t2.schedule(new TimerTask(){

                @Override
                public void run() {
                    Log.info("Timeout command " + (String)command.get(0), null);
                    process.destroy();
                }
            }, timeout * 1000);
        }
        StreamEater errEater = new StreamEater("err", process.getErrorStream());
        StreamEater outEater = new StreamEater("out", process.getInputStream());
        Thread a2 = new Thread(errEater);
        a2.start();
        Thread b2 = new Thread(outEater);
        b2.start();
        try {
            exit = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (t2 != null) {
            t2.cancel();
        }
        process.destroy();
        return exit;
    }

    public static int exec(final String commandLine, String[] env, File dir, int timeout) throws IOException {
        int exit = 0;
        Runtime runtime = Runtime.getRuntime();
        final Process process = runtime.exec(commandLine, env, dir);
        Timer t2 = null;
        if (timeout > 0) {
            t2 = new Timer(true);
            t2.schedule(new TimerTask(){

                @Override
                public void run() {
                    Log.info("Timeout command " + commandLine, null);
                    process.destroy();
                }
            }, timeout * 1000);
        }
        StreamEater errEater = new StreamEater("err", process.getErrorStream());
        StreamEater outEater = new StreamEater("out", process.getInputStream());
        Thread a2 = new Thread(errEater);
        a2.start();
        Thread b2 = new Thread(outEater);
        b2.start();
        try {
            exit = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return exit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int exec(String commandLine, List<String> env, File dir, StringBuilder buffer, int timeout) throws IOException {
        int exit = 0;
        Process process = Runtime.getRuntime().exec(commandLine.split(" "), env != null ? env.toArray(new String[0]) : null, dir);
        StreamEater errEater = new StreamEater("err", process.getErrorStream());
        StreamEater outEater = new StreamEater("out", process.getInputStream(), buffer);
        Thread a2 = new Thread(errEater);
        a2.start();
        Thread b2 = new Thread(outEater);
        b2.start();
        if (timeout > 0) {
            ExecutorService service = Executors.newSingleThreadExecutor();
            try {
                CallableProcess call = new CallableProcess(process);
                Future<Integer> future = service.submit(call);
                exit = future.get(timeout, TimeUnit.SECONDS);
            }
            catch (InterruptedException e2) {
                process.destroy();
                Thread.currentThread().interrupt();
            }
            catch (TimeoutException e3) {
                process.destroy();
            }
            catch (Exception e4) {
                exit = 1;
            }
            finally {
                service.shutdown();
            }
        }
        try {
            exit = process.waitFor();
        }
        catch (InterruptedException e5) {
            Thread.currentThread().interrupt();
        }
        try {
            process.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return exit;
    }

    static class StreamEater
    implements Runnable {
        private InputStream stream;
        private String prefix;
        private StringBuilder buffer;

        public StreamEater(String prefix, InputStream stream) {
            this.prefix = prefix;
            this.stream = stream;
        }

        public StreamEater(String prefix, InputStream stream, StringBuilder buffer) {
            this.prefix = prefix;
            this.stream = stream;
            this.buffer = buffer;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.stream);
                BufferedReader br = new BufferedReader(isr);
                String line = br.readLine();
                while (line != null) {
                    Log.info(this.prefix + ": " + line, null);
                    if (this.buffer != null) {
                        if (!this.buffer.toString().isEmpty()) {
                            this.buffer.append("\n");
                        }
                        this.buffer.append(line);
                    }
                    line = br.readLine();
                }
                br.close();
            }
            catch (IOException e2) {
                Log.error(e2.getMessage(), e2);
            }
        }
    }

    static class CallableProcess
    implements Callable<Integer> {
        private Process p;

        public CallableProcess(Process process) {
            this.p = process;
        }

        @Override
        public Integer call() throws Exception {
            return this.p.waitFor();
        }
    }
}

