/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.update;

import com.logicaldoc.installer.update.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class WindowsReqistry {
    public static final String read(String key, String name) {
        try {
            Process process = Runtime.getRuntime().exec("reg query \"" + key + "\" /v " + name);
            StreamReader reader = new StreamReader(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join();
            String output = reader.getResult();
            output = output.substring(output.lastIndexOf("REG_") + 8, output.length() - 1).trim();
            if (output.startsWith("D") && output.contains("0x")) {
                output = output.substring(output.indexOf("0x") + 2);
                int decimal = Integer.parseInt(output, 16);
                return Integer.toString(decimal);
            }
            return output;
        }
        catch (IndexOutOfBoundsException process) {
        }
        catch (Exception e2) {
            Log.error("WindowsRegistry: " + e2.getMessage(), e2);
        }
        return null;
    }

    public static final void update(String key, String name, String value, String type) {
        try {
            Process process = Runtime.getRuntime().exec("reg add \"" + key + "\" /v " + name + " /t " + type + " /f /d \"" + value + "\"");
            StreamReader reader = new StreamReader(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join();
            reader.getResult();
        }
        catch (IndexOutOfBoundsException process) {
        }
        catch (Exception e2) {
            e2.printStackTrace();
            Log.error("WindowsRegistry: " + e2.getMessage(), e2);
        }
    }

    public static final void removeKey(String key) {
        try {
            Process process = Runtime.getRuntime().exec("reg delete \"" + key + "\" /f");
            StreamReader reader = new StreamReader(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join();
        }
        catch (IndexOutOfBoundsException process) {
        }
        catch (Exception e2) {
            Log.error("WindowsRegistry: " + e2.getMessage(), e2);
        }
    }

    public static List<String> getLocalProfilesSIDs() {
        ArrayList<String> ids = new ArrayList<String>();
        try {
            String[] lines;
            Process process = Runtime.getRuntime().exec("reg query \"HKLM\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\ProfileList\"");
            StreamReader reader = new StreamReader(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join();
            String output = reader.getResult();
            for (String line : lines = output.split(System.getProperty("line.separator"))) {
                if (!line.contains("\\CurrentVersion\\ProfileList") || line.endsWith("\\CurrentVersion\\ProfileList")) continue;
                ids.add(line.substring(line.lastIndexOf(92) + 1));
            }
        }
        catch (IndexOutOfBoundsException process) {
        }
        catch (Exception e2) {
            Log.error("WindowsRegistry: " + e2.getMessage(), e2);
        }
        return ids;
    }

    public static void main(String[] args) {
        System.out.println(WindowsReqistry.read("HKLM\\SOFTWARE\\WOW6432Node\\Apache Software Foundation\\Procrun 2.0\\LogicalDOC\\Parameters\\Java", "Jvm"));
        String val = WindowsReqistry.read("HKLM\\SOFTWARE\\WOW6432Node\\Apache Software Foundation\\Procrun 2.0\\LogicalDOC\\Parameters\\Java", "JvmMx");
        System.out.println(val);
    }

    static class StreamReader
    extends Thread {
        private InputStream is;
        private StringWriter sw = new StringWriter();

        public StreamReader(InputStream is) {
            this.is = is;
        }

        @Override
        public void run() {
            try {
                int c2;
                while ((c2 = this.is.read()) != -1) {
                    this.sw.write(c2);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String getResult() {
            return this.sw.toString();
        }
    }
}

