/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.update;

import com.logicalobjects.jlicense.license.LicenseManager;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class LicenseTask
extends Task {
    private String license;
    private String checkPatches = "true";
    private String checkUpdates = "true";

    public void execute() throws BuildException {
        File licenseFile = new File(this.license);
        if (!(licenseFile.exists() && licenseFile.isFile() && licenseFile.canRead())) {
            throw new BuildException("Unable to find the license file " + this.license);
        }
        try {
            LicenseManager manager = LicenseManager.getInstance((String)licenseFile.getPath(), (String)"");
            if (!manager.isValid()) {
                throw new Exception("License is not valid");
            }
            if (LicenseTask.isSupportExpired()) {
                throw new Exception("Your support contract expired");
            }
            if (!this.isPatchesEnabled()) {
                throw new Exception("Patches are disabled");
            }
            if (!this.isUpdatesEnabled()) {
                throw new Exception("Updates are disabled");
            }
        }
        catch (Exception e2) {
            throw new BuildException(e2.getMessage());
        }
    }

    private static boolean isSupportExpired() throws ParseException {
        String expiration = LicenseManager.getInstance().getFeature("SupportExpiration");
        if (expiration == null || expiration.trim().isEmpty() || expiration.indexOf("never") != -1) {
            return false;
        }
        Date now = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date licDate = df.parse(expiration);
        return now.compareTo(licDate) > 0;
    }

    private boolean isUpdatesEnabled() throws ParseException {
        if (!"true".equals(this.checkUpdates)) {
            return true;
        }
        String val = LicenseManager.getInstance().getFeature("Feature_35");
        return "enabled".equals(val);
    }

    private boolean isPatchesEnabled() throws ParseException {
        if (!"true".equals(this.checkPatches)) {
            return true;
        }
        String val = LicenseManager.getInstance().getFeature("Feature_41");
        return "enabled".equals(val);
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getCheckPatches() {
        return this.checkPatches;
    }

    public String getCheckUpdates() {
        return this.checkUpdates;
    }

    public void setCheckPatches(String checkPatches) {
        this.checkPatches = checkPatches;
    }

    public void setCheckUpdates(String checkUpdates) {
        this.checkUpdates = checkUpdates;
    }
}

