/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.update;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;

public class JtdsToSQLServer {
    public static void main(String[] args) throws IOException {
        String database;
        Properties config = new Properties();
        config.load(new FileReader(args[0]));
        String src = config.getProperty("jdbc.url");
        if (!src.startsWith("jdbc:jtds:sqlserver:")) {
            System.out.println("Current database is not SQL Server, no need to touch the configuration");
            System.exit(0);
        }
        System.out.println("Found SQL Server connection URL: " + src);
        URL url = new URL(src.replace("jdbc:jtds:sqlserver", "http"));
        String host = url.getHost();
        int port = url.getPort();
        if (port == -1) {
            port = 1433;
        }
        if ((database = url.getPath().substring(url.getPath().lastIndexOf(47) + 1)).contains(";")) {
            database = database.substring(0, database.indexOf(59));
        }
        String instance = "";
        if (url.getPath().contains("instance=") && (instance = url.getPath().substring(url.getPath().lastIndexOf("instance=") + 9)).contains(";")) {
            instance = instance.substring(0, instance.indexOf(59));
        }
        String template = "jdbc:sqlserver://%s:%d;databaseName=%s;instanceName=%s";
        String dst = String.format(template, host, port, database, instance);
        System.out.println("New converted SQL Server URL: " + src);
        config.setProperty("jdbc.url", dst);
        JtdsToSQLServer.write(config, new File(args[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(Properties prop, File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            prop.store(fos, "");
        }
        finally {
            if (fos != null) {
                try {
                    fos.flush();
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

