/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.logicaldoc;

import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.installer.update.WindowsReqistry;
import com.logicaldoc.installer.util.Exec;
import com.logicaldoc.installer.util.FileUtil;
import com.logicaldoc.installer.util.Log;
import com.logicaldoc.installer.util.ServiceUtil;
import com.logicaldoc.installer.util.Wget;
import com.logicaldoc.installer.util.WinFirewall;
import com.logicaldoc.installer.util.WinKill;
import java.awt.Desktop;
import java.io.File;
import java.io.FileWriter;
import java.util.List;
import java.util.Locale;

public class StartApplication {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(AbstractUIProcessHandler handler, String[] args) {
        try {
            int count;
            String root = args[0].trim();
            if (!root.endsWith("/")) {
                root = root + "/";
            }
            int port = Integer.parseInt(args[1].trim());
            String service = args[2].trim();
            String lang = args[3].trim();
            try {
                if (FileUtil.isWindows()) {
                    this.grantServicePermissions(service);
                    Exec.exec("net start " + service, null, null, 60);
                    Exec.exec("net start " + service + "-Update", null, null, 60);
                } else {
                    Exec.exec(root + "bin/logicaldoc.sh start", null, null, 60);
                    Exec.exec(root + "update-wd/update-wd.sh start", null, null, 60);
                }
            }
            catch (Exception e2) {
                Log.error(e2.getMessage(), e2);
            }
            for (count = 0; count < 60 && !Wget.wget("http://localhost:" + port + "/frontend.jsp").contains("UP AND RUNNING"); ++count) {
                StartApplication startApplication = this;
                synchronized (startApplication) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException e3) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
            }
            try {
                if (FileUtil.isWindows()) {
                    Exec.exec("net stop " + service, null, null, 120);
                } else {
                    Exec.exec(root + "bin/logicaldoc.sh stop", null, null, 120);
                }
            }
            catch (Exception e4) {
                Log.error(e4.getMessage(), e4);
            }
            for (count = 0; count < 120 && Wget.wget("http://localhost:" + port + "/frontend.jsp").contains("UP AND RUNNING"); ++count) {
                StartApplication e4 = this;
                synchronized (e4) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException e5) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
            }
            if (FileUtil.isWindows()) {
                WinKill.killTomcatProcess();
            }
            try {
                File[] logs;
                File logsRoot = new File(root + "repository/logs");
                for (File log : logs = logsRoot.listFiles()) {
                    if (!log.isFile()) continue;
                    log.delete();
                }
            }
            catch (Exception e6) {
                Log.error(e6.getMessage(), e6);
            }
            try {
                if (FileUtil.isWindows()) {
                    Exec.exec("net start " + service, null, null, 60);
                } else {
                    Exec.exec(root + "bin/logicaldoc.sh start", null, null, 120);
                }
            }
            catch (Exception e7) {
                Log.error(e7.getMessage(), e7);
            }
            handler.logOutput("Application started", false);
            String tip = I18N.message("installationend", new Locale(lang), new String[]{"LogicalDOC"});
            tip = tip + "\n\nhttp://localhost:" + port;
            tip = tip.replace("\n", "\r\n");
            handler.logOutput(tip, false);
            File file = new File(root + "bin/enter.txt");
            FileWriter writer = new FileWriter(file);
            writer.write(tip);
            writer.flush();
            writer.close();
            if (FileUtil.isWindows()) {
                try {
                    WinFirewall.openPort(port);
                }
                catch (Exception e8) {
                    Log.error("Unable to open the port " + port + " in the firewall, please make sure this port is accessible from outside", null);
                }
            }
            try {
                Desktop.getDesktop().open(file);
            }
            catch (Exception exception) {}
        }
        catch (Exception e9) {
            Log.error(e9.getMessage(), e9);
        }
    }

    private void grantServicePermissions(String serviceName) {
        List<String> profileIds = WindowsReqistry.getLocalProfilesSIDs();
        for (String profileId : profileIds) {
            ServiceUtil.grantPermissions(serviceName, profileId);
        }
    }
}

