/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.logicaldoc;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.logicaldoc.installer.logicaldoc.InstallLibreOffice;
import com.logicaldoc.installer.util.FileUtil;
import com.logicaldoc.installer.util.Log;
import com.logicaldoc.installer.util.ServiceUtil;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;

public class RegistrationValidator
implements DataValidator {
    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getErrorMessageId() {
        return "";
    }

    @Override
    public String getWarningMessageId() {
        return "";
    }

    @Override
    public DataValidator.Status validateData(InstallData data) {
        try {
            String root = data.getVariable("INSTALL_PATH");
            data.setVariable("maxmemory", this.memoryProposal());
            data.setVariable("servicename", this.serviceName());
            data.setVariable("openoffice", InstallLibreOffice.libreOfficePathProposal(root));
            if (FileUtil.isWindows()) {
                if (!root.endsWith("\\")) {
                    root = root + "\\";
                }
                data.setVariable("convert", root + "imagemagick\\convert.exe");
                data.setVariable("ghostscript", root + "ghostscript\\bin\\gs.exe");
                data.setVariable("tesseract", root + "tesseract\\tesseract.exe");
                data.setVariable("clamscan", root + "clamav\\clamscan.exe");
                data.setVariable("openssl", root + "openssl\\bin\\openssl.exe");
                data.setVariable("pdftohtml", root + "xpdf\\pdftohtml.exe");
                data.setVariable("keytool", System.getProperty("java.home") + "\\bin\\keytool.exe");
            } else {
                data.setVariable("convert", "/usr/bin/convert");
                data.setVariable("ghostscript", "/usr/bin/gs");
                data.setVariable("tesseract", "/usr/local/bin/tesseract");
                data.setVariable("clamscan", "/usr/bin/clamscan");
                data.setVariable("openssl", "/usr/bin/openssl");
                data.setVariable("pdftohtml", "/usr/bin/pdftohtml");
                data.setVariable("keytool", System.getProperty("java.home") + "/bin/keytool");
            }
            data.setVariable("architecture", "64bit");
        }
        catch (Exception t2) {
            Log.error(t2.getMessage(), t2);
        }
        return DataValidator.Status.OK;
    }

    private String memoryProposal() {
        try {
            long maxMem = ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalPhysicalMemorySize() * 3L / 4L;
            maxMem = maxMem / 1024L / 1024L;
            maxMem = maxMem * 3L / 4L;
            if (maxMem < 900L) {
                maxMem = 900L;
            }
            return Long.toString(maxMem);
        }
        catch (Exception t2) {
            Log.error(t2.getMessage(), t2);
            return "900";
        }
    }

    private String serviceName() {
        if (FileUtil.isWindows()) {
            return ServiceUtil.findSuitableName("LogicalDOC");
        }
        return "";
    }
}

