/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.logicaldoc;

import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import com.logicaldoc.installer.util.FileUtil;
import com.logicaldoc.installer.util.LicenseRequest;
import com.logicaldoc.installer.util.Log;
import com.logicalobjects.jlicense.license.SystemInfo;
import java.io.File;
import java.io.FileReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;

public class LicenseActivation {
    public void run(AbstractUIProcessHandler handler, String[] args) {
        String rootDir = args[0].trim();
        String userNo = args[1].trim();
        Log.info("Activating UserNo: " + userNo, null);
        String ret = this.activate(userNo, new File(rootDir + "/conf/license.lic"), new File(rootDir));
        handler.logOutput("License activation: " + ret, false);
        Log.info("License activation: " + ret, null);
    }

    public static String generateRequest(String userNo, String release) {
        StringBuilder sb = new StringBuilder();
        try {
            LicenseRequest request = new LicenseRequest();
            request.put("license.activationCode", userNo != null ? userNo : "");
            request.put("release", release);
            try {
                request.put("computerName", SystemInfo.getComputerName());
            }
            catch (Exception t2) {
                Log.warn("Cannot retrieve the computer's name", t2);
            }
            try {
                request.put("sid", SystemInfo.getSID());
            }
            catch (Exception t3) {
                Log.warn("Cannot retrieve the system's ID", t3);
            }
            sb.append(request.store());
        }
        catch (Exception t4) {
            Log.error("", t4);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String activate(String activationCode, File licenseFile, File installDir) {
        HttpURLConnection connection = null;
        try {
            String release = "";
            try {
                Properties config = new Properties();
                File conf = new File(installDir, "conf");
                conf = new File(conf, "context.properties");
                config.load(new FileReader(conf));
                release = config.getProperty("product.release", "");
            }
            catch (Exception config) {
                // empty catch block
            }
            String activationRequest = LicenseActivation.generateRequest(activationCode, release);
            Log.info("Generated the activation request:\n" + activationRequest, null);
            String activationBody = "userno=" + activationCode + "&activationRequest=" + LicenseActivation.generateRequest(activationCode, release);
            String activationUrl = "http://activation.logicaldoc.com/weblicense/activation/activate";
            URL url = new URL(activationUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setInstanceFollowRedirects(false);
            connection.setUseCaches(false);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
            writer.write(activationBody);
            writer.flush();
            writer.close();
            int result = connection.getResponseCode();
            Log.info("Got LM response: " + result + " - " + connection.getResponseMessage(), null);
            if (result == 501) {
                String string = "invaliduserno";
                return string;
            }
            if (result != 200) {
                String string = "servererror";
                return string;
            }
            FileUtil.writeToFile(connection.getInputStream(), licenseFile);
            String string = "ok";
            return string;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            Log.error("Activation Error: " + e2.getMessage(), e2);
            String string = "servererror";
            return string;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

