/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.logicaldoc;

import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import com.logicaldoc.installer.util.Exec;
import com.logicaldoc.installer.util.FileUtil;
import com.logicaldoc.installer.util.Log;
import com.logicaldoc.installer.util.PortUtil;
import com.logicaldoc.installer.util.ServiceUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Scanner;

public class InstallMariaDB {
    public static String serviceName = "";
    public static int servicePort = 3350;

    public static void main(String[] args) throws IOException {
        File exe = new InstallMariaDB().retrieveMariaDBInstallDbExeFromRegistry();
        System.out.println(exe.getPath());
    }

    public void run(AbstractUIProcessHandler handler, String[] args) {
        String installDir = args[0].trim();
        File embeddedMariaDB = new File(installDir, "mariadb");
        if (!FileUtil.isWindows() || !embeddedMariaDB.exists()) {
            Log.info("MariaDB will not be installed", null);
            return;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add("msiexec");
        command.add("/i");
        command.add(installDir + "\\mariadb\\mariadb.msi");
        command.add("/qn");
        command.add("/norestart");
        command.add("ALLUSERS=1");
        serviceName = ServiceUtil.findSuitableName("MariaDBldoc");
        Log.info("Using database service name " + serviceName, null);
        command.add("SERVICENAME=" + serviceName);
        servicePort = PortUtil.findSuitablePort(servicePort);
        command.add("DATADIR=\"" + installDir + "\\repository\\db\"");
        command.add("PORT=" + servicePort);
        command.add("PASSWORD=logicaldoc");
        command.add("UTF8=utf8");
        command.add("/L");
        command.add(installDir + "\\mariadb\\install.log");
        File dbDir = new File(installDir + "/repository/db");
        Log.info("Clear directory: " + dbDir, null);
        this.deleteDirectory(dbDir);
        dbDir.mkdir();
        try {
            Log.info("Executing command: " + command, null);
            Exec.exec(command);
            Log.info("MariaDB installer completed", null);
        }
        catch (Exception e2) {
            Log.error(e2.getMessage(), e2);
        }
        if (dbDir.listFiles().length == 0) {
            Log.info("MariaDB was already installed in this computer", null);
            try {
                FileUtil.writeFile(serviceName, new File(installDir + "/mariadb/mariadb.instance").getPath());
                File mariadbInstallDb = this.retrieveMariaDBInstallDbExeFromLog(new File(installDir + "/mariadb/install.log"));
                if (mariadbInstallDb == null) {
                    mariadbInstallDb = this.retrieveMariaDBInstallDbExeFromRegistry();
                }
                if (mariadbInstallDb == null) {
                    new IOException("Cannot locate mariadb-install-db.exe");
                }
                Log.info("Creating a new MariaDB instance using the command " + mariadbInstallDb.getAbsolutePath(), null);
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.add(mariadbInstallDb.getPath());
                cmd.add("--datadir=\"" + installDir + "\\repository\\db\"");
                cmd.add("--service=" + serviceName);
                cmd.add("--port=" + servicePort);
                cmd.add("--password=logicaldoc");
                cmd.add("-s");
                int ret = Exec.exec(cmd);
                if (ret == 0) {
                    Log.info("New MariaDB instance created", null);
                    Log.info("Starting service " + serviceName, null);
                    Exec.exec("net start " + serviceName, null, null, 120);
                    Log.info("Service " + serviceName + " started", null);
                }
            }
            catch (Exception e3) {
                Log.error(e3.getMessage(), e3);
            }
        }
        Log.info("MariaDB has been installed", null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File retrieveMariaDBInstallDbExeFromRegistry() throws IOException {
        StringBuilder sw = new StringBuilder();
        new Exec().exec("reg query HKLM\\SOFTWARE\\", null, null, sw, 120);
        while (sw.toString().isEmpty()) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        try (Scanner scanner = new Scanner(new StringReader(sw.toString()));){
            File file;
            block11: {
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    if (!line.toLowerCase().contains("mariadb")) continue;
                    Log.info("Got registry key " + line, null);
                    StringBuilder sb = new StringBuilder();
                    String commandLine = "reg query \"" + line + "\" /v INSTALLDIR";
                    new Exec().exec(commandLine, null, null, sb, 120);
                    String value = sb.toString();
                    value = value.substring(value.indexOf("REG_SZ") + 6).trim();
                    Log.info("Retrieved MariaDB installation path: " + line, null);
                    file = new File(value + "/bin/mariadb-install-db.exe");
                    if (!file.exists()) {
                        continue;
                    }
                    break block11;
                }
                return null;
            }
            File file2 = file;
            return file2;
        }
    }

    private File retrieveMariaDBInstallDbExeFromLog(File installationLogFile) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(installationLogFile), StandardCharsets.UTF_16);
             BufferedReader br = new BufferedReader(in);){
            String str;
            while ((str = br.readLine()) != null) {
                if (!str.startsWith("CheckDBInUse:  MySQL/MariaDB") || !str.contains("CommandLine")) continue;
                lines.add(str);
            }
        }
        for (String line : lines) {
            File installDir = this.extractInstallationBinFromLogLine(line);
            File mariadbInstallDb = new File(installDir, "mariadb-install-db.exe");
            if (!mariadbInstallDb.exists()) continue;
            return mariadbInstallDb;
        }
        return null;
    }

    private File extractInstallationBinFromLogLine(String line) {
        line = line.substring(line.indexOf("CommandLine"));
        line = line.substring(line.indexOf(34) + 1);
        line = line.substring(0, line.indexOf(34));
        File file = new File(line.trim());
        while (file.isFile()) {
            file = file.getParentFile();
        }
        return file;
    }

    private void deleteDirectory(File directoryToBeDeleted) {
        File[] contents = directoryToBeDeleted.listFiles();
        if (contents != null) {
            for (File f2 : contents) {
                this.deleteDirectory(f2);
            }
        }
        directoryToBeDeleted.delete();
    }
}

