/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.logicaldoc;

import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import com.logicaldoc.installer.logicaldoc.InstallLibreOffice;
import com.logicaldoc.installer.logicaldoc.InstallMariaDB;
import com.logicaldoc.installer.util.FileUtil;
import com.logicaldoc.installer.util.JavaUtil;
import com.logicaldoc.installer.util.Log;
import com.logicaldoc.installer.util.Replace;
import com.logicaldoc.util.config.ContextProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.UUID;

public class ApplyConfiguration {
    public void run(AbstractUIProcessHandler handler, String[] args) {
        try {
            String installDir = args[0].trim();
            String name = args[2].trim();
            String organization = args[3].trim();
            String email = args[4].trim();
            String website = args[5].trim();
            String dbms = args[6];
            dbms = "embedded".equals(dbms.trim()) ? "hsqldb" : dbms.trim();
            String dbdriver = args[7].trim();
            String dburl = args[8].trim();
            String dbuser = args[9].trim();
            String dbpassword = args[10].trim();
            String dbquery = args[11].trim();
            String dbdialect = args[12].trim();
            String dbport = args[14].trim();
            String dbdatabase = args[15].trim();
            if ("hsqldb".equals(dbms)) {
                dbdriver = "org.hsqldb.jdbc.JDBCDriver";
                dburl = ("jdbc:hsqldb:/" + installDir.replace("\\\\", "/") + "/repository//db/db").replace("//", "/");
                dbuser = "sa";
                dbpassword = "";
                dbquery = "SELECT 1 FROM INFORMATION_SCHEMA.SYSTEM_USERS";
                dbdialect = "org.hibernate.dialect.HSQLDialect";
            } else if (!InstallMariaDB.serviceName.isEmpty()) {
                dbms = "mariadb";
                dbdriver = "org.mariadb.jdbc.Driver";
                dburl = "jdbc:mariadb://localhost:" + InstallMariaDB.servicePort + "/logicaldoc";
                dbuser = "root";
                dbpassword = "logicaldoc";
                dbquery = "SELECT 1";
                dbdialect = "org.hibernate.dialect.MariaDB106Dialect";
                dbport = "" + InstallMariaDB.servicePort;
                dbdatabase = "logicaldoc";
            }
            Log.info("dbms: " + dbms, null);
            String httpPort = args[16].trim();
            String httpsPort = args[17].trim();
            String shutdownPort = args[18].trim();
            int memory = Integer.parseInt(args[19].trim());
            String servicename = args[20].trim();
            String inputedLibreOffice = args[21].trim();
            File inputedLibreOfficeDir = new File(inputedLibreOffice);
            File embeddedLibreOfficeOffice = new File(installDir, "libreoffice");
            Log.info("Inputed LibreOffice path: " + inputedLibreOfficeDir, null);
            if (FileUtil.isWindows() && inputedLibreOfficeDir.getPath().equals(embeddedLibreOfficeOffice.getPath())) {
                inputedLibreOffice = InstallLibreOffice.libreOfficePath(installDir);
            }
            Log.info("Using LibreOffice path: " + inputedLibreOfficeDir, null);
            String convert = args[22].trim();
            String ghostscript = args[23].trim();
            String tesseract = args[24].trim();
            String clamscan = args[25].trim();
            String openssl = args[26].trim();
            String keytool = args[27].trim();
            String lang = "en";
            if (args[28] != null && !args[28].contains("$")) {
                lang = args[28].trim();
            }
            String javahome = this.detectJDK();
            String jrehome = this.detectJRE();
            File contextFile = new File(installDir + "/conf/context.properties");
            Log.info("Save configurations into " + contextFile.getAbsolutePath(), null);
            handler.logOutput("Save configurations into " + contextFile.getAbsolutePath(), false);
            ContextProperties config = new ContextProperties(contextFile);
            config.setProperty("LDOCHOME", installDir);
            config.setProperty("id", UUID.randomUUID().toString());
            config.setProperty("reg.name", name);
            config.setProperty("reg.organization", organization);
            config.setProperty("reg.website", website);
            config.setProperty("reg.email", email);
            config.setProperty("jdbc.dbms", dbms);
            config.setProperty("jdbc.driver", dbdriver);
            config.setProperty("jdbc.url", dburl);
            config.setProperty("jdbc.username", dbuser);
            config.setProperty("jdbc.password", dbpassword);
            config.setProperty("jdbc.validationQuery", dbquery);
            config.setProperty("hibernate.dialect", dbdialect);
            config.setProperty("cluster.node.port", httpPort);
            config.setProperty("server.url", "http://my_server:" + httpPort);
            config.setProperty("converter.HtmlConverter.localUrl", "http://localhost:" + httpPort);
            String repoDir = installDir + "/repository/";
            config.setProperty("index.dir", repoDir + "index/");
            config.setProperty("conf.dbdir", repoDir + "db/");
            config.setProperty("conf.exportdir", repoDir + "impex/out/");
            config.setProperty("conf.importdir", repoDir + "impex/in/");
            config.setProperty("conf.logdir", repoDir + "logs/");
            config.setProperty("conf.plugindir", repoDir + "plugins/");
            config.setProperty("conf.userdir", repoDir + "users/");
            config.setProperty("store.1.dir", repoDir + "docs/");
            config.setProperty("converter.ImageConverter.path", convert);
            config.setProperty("converter.GhostscriptConverter.path", ghostscript);
            config.setProperty("command.openssl", openssl);
            config.setProperty("command.keytool", keytool);
            config.setProperty("antivirus.command", clamscan);
            config.setProperty("ocr.Tesseract.path", tesseract);
            config.setProperty("converter.LibreOfficeConverter.path", inputedLibreOffice);
            if ("mariadb".equalsIgnoreCase(dbms)) {
                config.setProperty("ai.vectorstore.ExtendedMariaDBVectorStore.driver", dbdriver);
                config.setProperty("ai.vectorstore.ExtendedMariaDBVectorStore.username", dbuser);
                config.setProperty("ai.vectorstore.ExtendedMariaDBVectorStore.password", dbpassword);
                config.setProperty("ai.vectorstore.ExtendedMariaDBVectorStore.url", dburl);
            }
            config.setProperty("initialized", "true");
            config.write();
            File allowedCommands = new File(installDir + "/conf/allowed-commands.txt");
            StringBuilder sb = new StringBuilder(FileUtil.readFileAsString(allowedCommands.getPath()));
            sb.append("\n" + convert);
            sb.append("\n" + ghostscript);
            sb.append("\n" + openssl);
            sb.append("\n" + keytool);
            sb.append("\n" + clamscan);
            sb.append("\n" + tesseract);
            FileUtil.writeFile(sb.toString(), allowedCommands.getAbsolutePath());
            File file = new File(installDir + "/conf/build.properties");
            Log.info("Save configurations into " + file.getAbsolutePath(), null);
            handler.logOutput("Save configurations into " + file.getAbsolutePath(), false);
            try {
                Replace.replace(file.getAbsolutePath(), "LDOCHOME", installDir.replace("\\", "/"));
                Replace.replace(file.getAbsolutePath(), "PORT", dbport);
                Replace.replace(file.getAbsolutePath(), "USER", dbuser);
                Replace.replace(file.getAbsolutePath(), "DATABASE", dbdatabase);
                Replace.replace(file.getAbsolutePath(), "SSERVICE", servicename);
                Replace.replace(file.getAbsolutePath(), "PASSWORD", dbpassword);
                Replace.replace(file.getAbsolutePath(), "DBSERVICE", InstallMariaDB.serviceName);
            }
            catch (Exception e2) {
                Log.error("Exception while editing build properties", e2);
            }
            file = new File(installDir + "/tomcat/conf/server.xml");
            Log.info("Save configurations into " + file.getAbsolutePath(), null);
            handler.logOutput("Save configurations into " + file.getAbsolutePath(), false);
            String serverContent = this.readFileAsString(file);
            serverContent = serverContent.replaceFirst("port=\"9005\"", "port=\"" + shutdownPort + "\"");
            serverContent = serverContent.replaceFirst("port=\"8080\"", "port=\"" + httpPort + "\"");
            serverContent = serverContent.replace("port=\"8443\"", "port=\"" + httpsPort + "\"");
            serverContent = serverContent.replace("redirectPort=\"8443\"", "redirectPort=\"" + httpsPort + "\"");
            FileWriter out = new FileWriter(file);
            out.write(serverContent);
            out.close();
            file = new File(installDir + "/loader/build.properties");
            Log.info("Save configurations into " + file.getAbsolutePath(), null);
            handler.logOutput("Save configurations into " + file.getAbsolutePath(), false);
            config = new ContextProperties(file);
            config.setProperty("lang.default", lang);
            config.write();
            file = new File(installDir + "/loader/build.xml");
            Log.info("Save configurations into " + file.getAbsolutePath(), null);
            handler.logOutput("Save configurations into " + file.getAbsolutePath(), false);
            try {
                Replace.replace(file.getAbsolutePath(), "database logicaldoc;", "database " + dbdatabase + ";");
            }
            catch (Exception e3) {
                Log.error("Exception while editing build properties", e3);
            }
            file = new File(installDir + "/bin/open.bat");
            String openBat = this.readFileAsString(file);
            openBat = openBat.replaceFirst("8080", httpPort);
            out = new FileWriter(file);
            out.write(openBat);
            out.close();
            file = new File(installDir + "/tomcat/bin/service.bat");
            Log.info("Save configuration into " + file.getAbsolutePath(), null);
            handler.logOutput("Save configurations into " + file.getAbsolutePath(), false);
            Replace.replace(file.getAbsolutePath(), "SSERVICE", servicename);
            Replace.replace(file.getAbsolutePath(), "SSERVNAME", servicename);
            String serviceBat = this.readFileAsString(file);
            serviceBat = serviceBat.replace("JvmMx=256", "JvmMx=" + memory);
            serviceBat = serviceBat.replace("JvmMs=256", "JvmMs=" + memory);
            if (!"-".equals(javahome)) {
                serviceBat = serviceBat.replace("setlocal", "set \"JAVA_HOME=" + javahome.replace("\\", "\\\\") + "\"\r\nset JRE_HOME=\r\nsetlocal\r\n");
            } else if (!"-".equals(jrehome)) {
                serviceBat = serviceBat.replace("setlocal", "set \"JRE_HOME=" + jrehome.replace("\\", "\\\\") + "\"\r\nset JAVA_HOME=\r\nsetlocal\r\n");
            }
            out = new FileWriter(file);
            out.write(serviceBat);
            out.close();
            file = new File(installDir + "/tomcat/bin/manager.bat");
            Log.info("Save configuration into " + file.getAbsolutePath(), null);
            handler.logOutput("Save configurations into " + file.getAbsolutePath(), false);
            Replace.replace(file.getAbsolutePath(), "SSERVICE", servicename);
            file = new File(installDir + "/bin/logicaldoc.bat");
            Log.info("Save configuration into " + file.getAbsolutePath(), null);
            handler.logOutput("Save configurations into " + file.getAbsolutePath(), false);
            Replace.replace(file.getAbsolutePath(), "-Xmx2000m", "-Xmx" + memory + "m");
            file = new File(installDir + "/bin/logicaldoc.sh");
            Log.info("Save configuration into " + file.getAbsolutePath(), null);
            handler.logOutput("Save configurations into " + file.getAbsolutePath(), false);
            Replace.replace(file.getAbsolutePath(), "-Xmx2000m", "-Xmx" + memory + "m");
            file = new File(installDir + "/update-wd/service.bat");
            Log.info("Save configuration into " + file.getAbsolutePath(), null);
            handler.logOutput("Save configurations into " + file.getAbsolutePath(), false);
            Replace.replace(file.getAbsolutePath(), "SSERVICE", servicename + "-Update");
            Replace.replace(file.getAbsolutePath(), "SSERVNAME", servicename + " Update");
            serviceBat = this.readFileAsString(file);
            if (!"-".equals(javahome)) {
                serviceBat = serviceBat.replace("setlocal", "set \"JAVA_HOME=" + javahome.replace("\\", "\\\\") + "\"\r\nset JRE_HOME=\r\nsetlocal\r\n");
            } else if (!"-".equals(jrehome)) {
                serviceBat = serviceBat.replace("setlocal", "set \"JRE_HOME=" + jrehome.replace("\\", "\\\\") + "\"\r\nset JAVA_HOME=\r\nsetlocal\r\n");
            }
            out = new FileWriter(file);
            out.write(serviceBat);
            out.close();
            file = new File(installDir + "/clamav/freshclam.conf");
            Log.info("Save configuration into " + file.getAbsolutePath(), null);
            if (file.exists()) {
                Replace.replace(file.getAbsolutePath(), "LDOCHOME", installDir);
            }
            file = new File(installDir + "/conf/log.xml");
            Log.info("Save configuration into " + file.getAbsolutePath(), null);
            Replace.replace(file.getAbsolutePath(), "[logs]", "[" + installDir + "/repository/logs]");
            if (!FileUtil.isWindows()) {
                File[] files;
                for (File f2 : files = new File(installDir + "/bin").listFiles()) {
                    if (!f2.getName().contains("logicaldoc") && !f2.getName().endsWith(".sh")) continue;
                    handler.logOutput("Make executable " + f2.getName(), false);
                    Log.info("Make executable " + f2.getName(), null);
                    f2.setExecutable(true);
                    Runtime.getRuntime().exec("chmod 777 " + f2.getAbsolutePath());
                }
                for (File f2 : files = new File(installDir + "/update-wd").listFiles()) {
                    if (!f2.getName().contains("update") && !f2.getName().endsWith(".sh")) continue;
                    handler.logOutput("Make executable " + f2.getName(), false);
                    Log.info("Make executable " + f2.getName(), null);
                    f2.setExecutable(true);
                    Runtime.getRuntime().exec("chmod 777 " + f2.getAbsolutePath());
                }
            }
            if (FileUtil.isWindows()) {
                Log.info("Granting Local Service full control into " + installDir, null);
                Log.info("Granted Local Service full control into " + installDir, null);
            }
        }
        catch (Exception e4) {
            Log.error(e4.getMessage(), e4);
        }
    }

    private String detectJDK() {
        Log.info("Checking Java JDK availability", null);
        String javahome = JavaUtil.getJDK();
        if (javahome == null) {
            javahome = "-";
        }
        Log.info("Found JDK home: " + javahome, null);
        return javahome;
    }

    private String detectJRE() {
        Log.info("Checking Java JRE availability", null);
        String jrehome = JavaUtil.getJRE();
        if (jrehome == null) {
            jrehome = "-";
        }
        Log.info("Found JRE home: " + jrehome, null);
        return jrehome;
    }

    private String readFileAsString(File file) throws IOException {
        StringBuilder fileData = new StringBuilder(1000);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }
}

