/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.hotfolder.ws;

import com.logicaldoc.installer.hotfolder.ws.WSFolder;
import com.logicaldoc.installer.util.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.ksoap2.SoapEnvelope;
import org.ksoap2.serialization.PropertyInfo;
import org.ksoap2.serialization.SoapObject;
import org.ksoap2.serialization.SoapSerializationEnvelope;
import org.ksoap2.transport.HttpTransportSE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebserviceClient {
    private static final String WS_NAMESPACE = "http://ws.logicaldoc.com";
    private static final int SOAP_VERSION = 110;
    private static int TIMEOUT = 60000;
    public static final String FEATURE_91 = "Feature_91";
    protected static Logger log = LoggerFactory.getLogger(WebserviceClient.class);

    public static boolean validateLicense(String url) {
        return WebserviceClient.listFeatures(url).contains(FEATURE_91);
    }

    private static WSFolder getFolderWithSid(String url, String sid, String path) {
        WSFolder folder = null;
        try {
            SoapObject request = new SoapObject(WS_NAMESPACE, "findByPath");
            request.addProperty("sid", (Object)sid);
            request.addProperty("path", (Object)path);
            String invocationUrl = url + (url.endsWith("/") ? "" : "/") + "services/Folder";
            log.info("Invoking " + invocationUrl);
            SoapSerializationEnvelope envelope = new SoapSerializationEnvelope(110);
            envelope.setOutputSoapObject((Object)request);
            HttpTransportSE transport = new HttpTransportSE(invocationUrl, TIMEOUT);
            transport.call("", (SoapEnvelope)envelope);
            SoapObject response = (SoapObject)envelope.getResponse();
            folder = new WSFolder();
            folder.setId(Long.parseLong(WebserviceClient.getProperty(response, "id")));
            folder.setParentId(Long.parseLong(WebserviceClient.getProperty(response, "parentId")));
            folder.setName(WebserviceClient.getProperty(response, "name"));
            folder.setType(Integer.parseInt(WebserviceClient.getProperty(response, "type")));
        }
        catch (Throwable t2) {
            Log.error(t2.getMessage(), t2);
        }
        return folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WSFolder getFolder(String url, String apiKey, String path) {
        String sid = WebserviceClient.login(url, apiKey);
        WSFolder folder = null;
        try {
            folder = WebserviceClient.getFolderWithSid(url, sid, path);
        }
        catch (Throwable t2) {
            Log.error(t2.getMessage(), t2);
        }
        finally {
            WebserviceClient.logout(url, sid);
        }
        return folder;
    }

    public static List<String> listFeatures(String url) {
        ArrayList<String> features = new ArrayList<String>();
        Log.info("Try to contact LogicalDOC: " + url, null);
        try {
            SoapObject request = new SoapObject(WS_NAMESPACE, "getInfo");
            String invocationUrl = url + (url.endsWith("/") ? "" : "/") + "services/System";
            System.out.println("Invoking " + invocationUrl);
            SoapSerializationEnvelope envelope = new SoapSerializationEnvelope(110);
            envelope.setOutputSoapObject((Object)request);
            HttpTransportSE transport = new HttpTransportSE(invocationUrl, TIMEOUT);
            transport.call("", (SoapEnvelope)envelope);
            SoapObject response = (SoapObject)envelope.getResponse();
            PropertyInfo pinfo = new PropertyInfo();
            for (int i2 = 0; i2 < response.getPropertyCount(); ++i2) {
                response.getPropertyInfo(i2, pinfo);
                if (!pinfo.getName().equals("features")) continue;
                features.add(response.getProperty(i2).toString());
            }
        }
        catch (Throwable t2) {
            Log.error(t2.getMessage(), t2);
        }
        return features;
    }

    public static String login(String url, String apiKey) {
        String sid = null;
        try {
            SoapObject request = new SoapObject(WS_NAMESPACE, "login");
            request.addProperty("apikey", (Object)apiKey);
            String invocationUrl = url + (url.endsWith("/") ? "" : "/") + "services/Auth";
            System.out.println("Invoking " + invocationUrl);
            SoapSerializationEnvelope envelope = new SoapSerializationEnvelope(110);
            envelope.setOutputSoapObject((Object)request);
            HttpTransportSE transport = new HttpTransportSE(invocationUrl, TIMEOUT);
            transport.call("", (SoapEnvelope)envelope);
            sid = envelope.getResponse().toString();
        }
        catch (Throwable t2) {
            Log.error(t2.getMessage(), t2);
        }
        return sid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testCredentials(String url, String apiKey) {
        String sid = null;
        try {
            sid = WebserviceClient.login(url, apiKey);
            if (sid == null || "".equals(sid)) {
                throw new IOException("Invalid credentials");
            }
            Log.info("Server connected", null);
            boolean bl = true;
            return bl;
        }
        catch (Throwable t2) {
            Log.error(t2.getMessage(), t2);
            boolean bl = false;
            return bl;
        }
        finally {
            WebserviceClient.logout(url, sid);
        }
    }

    public static void logout(String url, String sid) {
        if (sid == null) {
            return;
        }
        try {
            SoapObject request = new SoapObject(WS_NAMESPACE, "logout");
            request.addProperty("sid", (Object)sid);
            String invocationUrl = url + (url.endsWith("/") ? "" : "/") + "services/Auth";
            System.out.println("Invoking " + invocationUrl);
            SoapSerializationEnvelope envelope = new SoapSerializationEnvelope(110);
            envelope.setOutputSoapObject((Object)request);
            HttpTransportSE transport = new HttpTransportSE(invocationUrl, TIMEOUT);
            transport.call("", (SoapEnvelope)envelope);
        }
        catch (Throwable t2) {
            Log.error(t2.getMessage(), t2);
        }
    }

    private static String getProperty(SoapObject object, String name) {
        if (object == null) {
            return null;
        }
        PropertyInfo pinfo = new PropertyInfo();
        for (int i2 = 0; i2 < object.getPropertyCount(); ++i2) {
            object.getPropertyInfo(i2, pinfo);
            if (!pinfo.getName().equals(name)) continue;
            String val = object.getProperty(i2).toString();
            if (!"anyType{}".equals(val) && val != null) {
                return val;
            }
            return null;
        }
        return null;
    }
}

