/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.hotfolder;

import com.izforge.izpack.api.event.ProgressListener;
import com.izforge.izpack.api.event.UninstallerListener;
import com.logicaldoc.installer.util.Exec;
import com.logicaldoc.installer.util.FileUtil;
import com.logicaldoc.installer.util.WinKill;
import java.io.File;
import java.util.List;

public class Uninstall
implements UninstallerListener {
    private static boolean windowsServiceDeleted = false;

    @Override
    public void afterDelete(File arg0) {
    }

    @Override
    public void afterDelete(List<File> arg0, ProgressListener arg1) {
    }

    @Override
    public void beforeDelete(List<File> arg0) {
        this.deleteWindowsService(this.getServiceName());
    }

    @Override
    public void beforeDelete(File file) {
        this.deleteWindowsService(this.getServiceName());
    }

    @Override
    public void beforeDelete(List<File> arg0, ProgressListener arg1) {
        this.deleteWindowsService(this.getServiceName());
    }

    @Override
    public void initialise() {
    }

    @Override
    public boolean isFileListener() {
        return true;
    }

    private void deleteWindowsService(String baseName) {
        if (!FileUtil.isWindows() || windowsServiceDeleted) {
            return;
        }
        try {
            Exec.exec("sc stop " + baseName, null, null, 120);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Exec.exec("sc stop " + baseName, null, null, 120);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (FileUtil.isWindows()) {
            WinKill.killTomcatProcess();
        }
        try {
            Exec.exec("sc delete " + baseName, null, null, 120);
            windowsServiceDeleted = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Exec.exec("sc stop " + baseName + "-Update", null, null, 120);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Exec.exec("sc stop " + baseName + "-Update", null, null, 120);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Exec.exec("sc delete " + baseName + "-Update", null, null, 120);
            windowsServiceDeleted = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String getServiceName() {
        return "LogicalDOC-HotFolder";
    }
}

