/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.hotfolder;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.logicaldoc.installer.export.WebserviceClient;
import com.logicaldoc.installer.util.Log;

public class ConnectionValidator
implements DataValidator {
    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getErrorMessageId() {
        return "Invalid credentials or feature not enabled in the license";
    }

    @Override
    public String getWarningMessageId() {
        return "Invalid credentials or feature not enabled in the license";
    }

    @Override
    public DataValidator.Status validateData(InstallData data) {
        String url = data.getVariable("url");
        String apiKey = data.getVariable("apikey");
        boolean connected = WebserviceClient.validateLicense(url);
        if (!connected) {
            Log.info("URL " + url + " not valid", null);
            return DataValidator.Status.ERROR;
        }
        Log.info("Connected to URL " + url, null);
        connected = WebserviceClient.testCredentials(url, apiKey);
        if (!connected) {
            Log.info("URL " + url + " not valid", null);
            return DataValidator.Status.ERROR;
        }
        return DataValidator.Status.OK;
    }
}

