/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.backup;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.logicaldoc.installer.util.Log;
import java.io.File;

public class DatabaseValidator
implements DataValidator {
    private String error;

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getErrorMessageId() {
        return this.error;
    }

    @Override
    public String getWarningMessageId() {
        return "";
    }

    @Override
    public DataValidator.Status validateData(InstallData data) {
        Log.info("Checking " + data.getVariable("dbbackupcommand"), null);
        File backupCommand = new File(data.getVariable("dbbackupcommand"));
        if (!backupCommand.exists() && !backupCommand.canExecute()) {
            this.error = "Cannot find executable file " + backupCommand.getAbsolutePath();
            Log.error(this.error, null);
            return DataValidator.Status.ERROR;
        }
        File restoreCommand = new File(data.getVariable("dbrestorecommand"));
        if (!restoreCommand.exists() && !restoreCommand.canExecute()) {
            this.error = "Cannot find executable file " + restoreCommand.getAbsolutePath();
            Log.error(this.error, null);
            return DataValidator.Status.ERROR;
        }
        return DataValidator.Status.OK;
    }
}

