/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.backup;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.installer.util.Log;
import com.logicaldoc.util.config.ContextProperties;
import java.io.File;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;

public class BackupValidator
implements DataValidator {
    private String error;

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getErrorMessageId() {
        return this.error;
    }

    @Override
    public String getWarningMessageId() {
        return "";
    }

    @Override
    public DataValidator.Status validateData(InstallData data) {
        ContextProperties ldocConfig;
        String logicaldocHome = data.getVariable("logicaldochome");
        Log.info("Inspecting LogicalDOC deployment at " + logicaldocHome, null);
        File ldocConfigFile = new File(logicaldocHome + "/conf/context.properties");
        if (!ldocConfigFile.exists()) {
            this.error = I18N.message("cannotfindldocat", Locale.getDefault(), new String[]{logicaldocHome});
            return DataValidator.Status.ERROR;
        }
        try {
            ldocConfig = new ContextProperties(ldocConfigFile);
        }
        catch (Throwable e2) {
            Log.error(e2.getMessage(), e2);
            this.error = I18N.message("cannotfindldocat", Locale.getDefault(), new String[]{logicaldocHome});
            return DataValidator.Status.ERROR;
        }
        File licenseFile = new File(logicaldocHome + "/conf/license.lic");
        if (!licenseFile.exists()) {
            this.error = I18N.message("licenseinvalid");
            return DataValidator.Status.ERROR;
        }
        try {
            ContextProperties license = new ContextProperties(licenseFile);
            if (!"enabled".equals(((Properties)license).getProperty("Feature_76"))) {
                throw new Exception("Feature 76 is not enabled");
            }
        }
        catch (Throwable e3) {
            Log.error(e3.getMessage(), e3);
            this.error = I18N.message("featuredisabled");
            return DataValidator.Status.ERROR;
        }
        data.setVariable("dbusername", ldocConfig.getProperty("jdbc.username"));
        data.setVariable("dbpassword", ldocConfig.getProperty("jdbc.password"));
        try {
            String analyzedUrl = ldocConfig.getProperty("jdbc.url").substring(ldocConfig.getProperty("jdbc.url").indexOf("://"));
            analyzedUrl = "http" + analyzedUrl;
            Log.info("Analyze DB URL " + analyzedUrl, null);
            URL jdbcURL = new URL(analyzedUrl);
            data.setVariable("dbport", "" + jdbcURL.getPort());
            data.setVariable("dbhost", "" + jdbcURL.getHost());
            String database = jdbcURL.getPath();
            if (database.startsWith("/")) {
                database = database.substring(1);
            }
            if (database.contains("/")) {
                database.substring(0, database.indexOf(47));
            }
            data.setVariable("dbdatabase", "" + database);
        }
        catch (Throwable e4) {
            Log.error(e4.getMessage(), e4);
        }
        File backupTarget = new File(data.getVariable("backuptarget"));
        backupTarget.mkdirs();
        backupTarget.mkdir();
        if (!backupTarget.exists()) {
            this.error = I18N.message("cannotcreatefolder", Locale.getDefault(), new String[]{backupTarget.getAbsolutePath()});
            return DataValidator.Status.ERROR;
        }
        return DataValidator.Status.OK;
    }
}

