/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.xmlmerge.action;

import com.izforge.izpack.util.xmlmerge.AbstractXmlMergeException;
import com.izforge.izpack.util.xmlmerge.Action;
import com.izforge.izpack.util.xmlmerge.DocumentException;
import com.izforge.izpack.util.xmlmerge.ElementException;
import com.wutka.dtd.DTD;
import com.wutka.dtd.DTDAny;
import com.wutka.dtd.DTDContainer;
import com.wutka.dtd.DTDElement;
import com.wutka.dtd.DTDItem;
import com.wutka.dtd.DTDName;
import com.wutka.dtd.DTDParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import org.jdom2.Content;
import org.jdom2.Element;

public class DtdInsertAction
implements Action {
    private static final Logger logger = Logger.getLogger(DtdInsertAction.class.getName());
    static Map<String, DTD> s_dtdMap = new Hashtable<String, DTD>();

    @Override
    public void perform(Element originalElement, Element patchElement, Element outputParentElement) throws AbstractXmlMergeException {
        Element element = originalElement != null ? originalElement.clone() : patchElement.clone();
        DTD dtd = this.getDTD(outputParentElement);
        Vector dtdElements = dtd.getItemsByType(DTDElement.class);
        DTDElement parentDtdElement = null;
        for (DTDElement dtdElement : dtdElements) {
            if (!dtdElement.getName().equals(outputParentElement.getName())) continue;
            parentDtdElement = dtdElement;
        }
        if (parentDtdElement == null) {
            throw new ElementException(element, "Element " + outputParentElement.getName() + " not defined in DTD");
        }
        DTDItem item = parentDtdElement.getContent();
        if (item instanceof DTDAny) {
            outputParentElement.addContent((Content)element);
        } else if (item instanceof DTDContainer) {
            List existingChildren = outputParentElement.getChildren();
            if (existingChildren.size() == 0) {
                outputParentElement.addContent((Content)element);
            } else {
                List<String> orderedDtdElements = this.getOrderedDtdElements((DTDContainer)item);
                int indexOfNewElementInDtd = orderedDtdElements.indexOf(element.getName());
                logger.fine("index of element " + element.getName() + ": " + indexOfNewElementInDtd);
                int pos = existingChildren.size();
                for (int i2 = 0; i2 < existingChildren.size(); ++i2) {
                    String elementName = ((Element)existingChildren.get(i2)).getName();
                    logger.fine("index of child " + elementName + ": " + orderedDtdElements.indexOf(elementName));
                    if (orderedDtdElements.indexOf(elementName) <= indexOfNewElementInDtd) continue;
                    pos = i2;
                    break;
                }
                logger.fine("adding element " + element.getName() + " add in pos " + pos);
                outputParentElement.addContent(pos, (Content)element);
            }
        }
    }

    public DTD getDTD(Element element) throws DocumentException {
        if (element.getDocument().getDocType() != null) {
            String systemId = element.getDocument().getDocType().getSystemID();
            DTD dtd = s_dtdMap.get(systemId);
            if (dtd == null) {
                InputStreamReader reader;
                try {
                    URL url = new URL(systemId);
                    reader = new InputStreamReader(url.openStream());
                }
                catch (MalformedURLException e2) {
                    throw new DocumentException(element.getDocument(), (Throwable)e2);
                }
                catch (IOException ioe) {
                    throw new DocumentException(element.getDocument(), (Throwable)ioe);
                }
                try {
                    dtd = new DTDParser((Reader)reader).parse();
                }
                catch (IOException ioe) {
                    throw new DocumentException(element.getDocument(), (Throwable)ioe);
                }
                s_dtdMap.put(systemId, dtd);
            }
            return dtd;
        }
        throw new DocumentException(element.getDocument(), "No DTD specified in document " + element.getDocument());
    }

    public List<String> getOrderedDtdElements(DTDContainer container) {
        DTDItem[] items;
        ArrayList<String> result = new ArrayList<String>();
        for (DTDItem item : items = container.getItems()) {
            if (item instanceof DTDContainer) {
                result.addAll(this.getOrderedDtdElements((DTDContainer)item));
                continue;
            }
            if (!(item instanceof DTDName)) continue;
            result.add(((DTDName)item).getValue());
        }
        return result;
    }
}

