/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.regex;

import com.izforge.izpack.util.regex.JavaRegexpMatcher;
import com.izforge.izpack.util.regex.RegexUtil;
import com.izforge.izpack.util.regex.Regexp;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaRegexp
extends JavaRegexpMatcher
implements Regexp {
    protected int getSubsOptions(int options) {
        int subsOptions = 1;
        if (RegexUtil.hasFlag(options, 16)) {
            subsOptions = 16;
        }
        return subsOptions;
    }

    @Override
    public String substitute(String input, String argument, int options) throws RuntimeException {
        StringBuffer subst = new StringBuffer();
        for (int i2 = 0; i2 < argument.length(); ++i2) {
            char c2 = argument.charAt(i2);
            if (c2 == '$') {
                subst.append('\\');
                subst.append('$');
                continue;
            }
            if (c2 == '\\') {
                if (++i2 < argument.length()) {
                    c2 = argument.charAt(i2);
                    int value = Character.digit(c2, 10);
                    if (value > -1) {
                        subst.append("$").append(value);
                        continue;
                    }
                    subst.append(c2);
                    continue;
                }
                subst.append('\\');
                continue;
            }
            subst.append(c2);
        }
        argument = subst.toString();
        int sOptions = this.getSubsOptions(options);
        Pattern p2 = this.getCompiledPattern(options);
        StringBuffer sb = new StringBuffer();
        Matcher m2 = p2.matcher(input);
        if (RegexUtil.hasFlag(sOptions, 16)) {
            sb.append(m2.replaceAll(argument));
        } else {
            boolean res = m2.find();
            if (res) {
                m2.appendReplacement(sb, argument);
                m2.appendTail(sb);
            } else {
                sb.append(input);
            }
        }
        return sb.toString();
    }
}

