/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.os;

import com.coi.tools.os.izpack.Registry;
import com.coi.tools.os.win.RegDataContainer;
import com.izforge.izpack.api.exception.NativeLibException;
import com.izforge.izpack.core.data.DefaultVariables;
import com.izforge.izpack.core.os.RegistryHandler;
import com.izforge.izpack.core.substitutor.VariableSubstitutorImpl;
import com.izforge.izpack.util.Librarian;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class Win_RegistryHandler
extends RegistryHandler {
    private final Librarian librarian;
    private Registry registry;

    public Win_RegistryHandler(Librarian librarian) {
        this.librarian = librarian;
    }

    @Override
    public void setValue(String key, String value, String contents) throws NativeLibException {
        Object ob;
        if (contents.contains("OLD_KEY_VALUE") && this.getRegistry().valueExist(key, value) && (ob = this.getRegistry().getValueAsObject(key, value)) instanceof String) {
            Properties props = new Properties();
            props.put("OLD_KEY_VALUE", ob);
            VariableSubstitutorImpl variableSubstitutor = new VariableSubstitutorImpl(new DefaultVariables(props));
            try {
                contents = variableSubstitutor.substitute(contents);
            }
            catch (Exception exception) {
                // empty catch block
            }
            contents = this.checkedPathContents(key, value, contents);
        }
        this.getRegistry().setValue(key, value, contents);
    }

    protected String checkedPathContents(String key, String value, String contents) {
        if (key.equalsIgnoreCase("SYSTEM\\CurrentControlSet\\Control Session Manager\\Environment") && value.equalsIgnoreCase("Path")) {
            String[] subPaths = contents.split(";");
            ArrayList<String> uniqueSubPaths = new ArrayList<String>();
            for (String subPath : subPaths) {
                if (subPath.length() <= 0 || this.containsIgnoreCase(uniqueSubPaths, subPath)) continue;
                uniqueSubPaths.add(subPath);
            }
            StringBuilder fixedContents = new StringBuilder();
            if (uniqueSubPaths.size() > 0) {
                fixedContents.append((String)uniqueSubPaths.get(0));
                for (int i2 = 1; i2 < uniqueSubPaths.size(); ++i2) {
                    fixedContents.append(";").append((String)uniqueSubPaths.get(i2));
                }
            }
            contents = fixedContents.toString();
        }
        return contents;
    }

    private boolean containsIgnoreCase(List<String> list, String s2) {
        for (String ele : list) {
            if (!ele.equalsIgnoreCase(s2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setValue(String key, String value, String[] contents) throws NativeLibException {
        this.getRegistry().setValue(key, value, contents);
    }

    @Override
    public void setValue(String key, String value, byte[] contents) throws NativeLibException {
        this.getRegistry().setValue(key, value, contents);
    }

    @Override
    public void setValue(String key, String value, long contents) throws NativeLibException {
        this.getRegistry().setValue(key, value, contents);
    }

    @Override
    public RegDataContainer getValue(String key, String value, RegDataContainer defaultVal) throws NativeLibException {
        if (this.valueExist(key, value)) {
            return this.getValue(key, value);
        }
        return defaultVal;
    }

    @Override
    public boolean keyExist(String key) throws NativeLibException {
        return this.getRegistry().keyExist(key);
    }

    @Override
    public boolean valueExist(String key, String value) throws NativeLibException {
        return this.getRegistry().valueExist(key, value);
    }

    @Override
    public String[] getSubkeys(String key) throws NativeLibException {
        return this.getRegistry().getSubkeys(key);
    }

    @Override
    public String[] getValueNames(String key) throws NativeLibException {
        return this.getRegistry().getValueNames(key);
    }

    @Override
    public RegDataContainer getValue(String key, String value) throws NativeLibException {
        return this.getRegistry().getValue(key, value);
    }

    @Override
    public void createKey(String key) throws NativeLibException {
        this.getRegistry().createKey(key);
    }

    @Override
    public void deleteKey(String key) throws NativeLibException {
        this.getRegistry().deleteKey(key);
    }

    @Override
    public void deleteKeyIfEmpty(String key) throws NativeLibException {
        this.getRegistry().deleteKeyIfEmpty(key);
    }

    @Override
    public void deleteValue(String key, String value) throws NativeLibException {
        this.getRegistry().deleteValue(key, value);
    }

    @Override
    public void setRoot(int i2) throws NativeLibException {
        this.getRegistry().setRoot(i2);
    }

    @Override
    public int getRoot() throws NativeLibException {
        return this.getRegistry().getRoot();
    }

    @Override
    public void setLogPrevSetValueFlag(boolean flagVal) throws NativeLibException {
        this.getRegistry().setLogPrevSetValueFlag(flagVal);
    }

    @Override
    public boolean getLogPrevSetValueFlag() throws NativeLibException {
        return this.getRegistry().getLogPrevSetValueFlag();
    }

    @Override
    public void activateLogging() throws NativeLibException {
        this.getRegistry().activateLogging();
    }

    @Override
    public void suspendLogging() throws NativeLibException {
        this.getRegistry().suspendLogging();
    }

    @Override
    public void resetLogging() throws NativeLibException {
        this.getRegistry().resetLogging();
    }

    @Override
    public List<Object> getLoggingInfo() throws NativeLibException {
        return this.getRegistry().getLoggingInfo();
    }

    @Override
    public void setLoggingInfo(List info) throws NativeLibException {
        this.getRegistry().setLoggingInfo(info);
    }

    @Override
    public void addLoggingInfo(List info) throws NativeLibException {
        this.getRegistry().addLoggingInfo(info);
    }

    @Override
    public void rewind() throws NativeLibException {
        this.getRegistry().rewind();
    }

    private synchronized Registry getRegistry() throws NativeLibException {
        if (this.registry == null) {
            try {
                this.registry = new Registry(this.librarian);
            }
            catch (Throwable exception) {
                throw new NativeLibException("Failed to create Registry: " + exception.getMessage(), exception);
            }
        }
        return this.registry;
    }
}

