/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.os;

import com.izforge.izpack.util.os.FileQueueCopy;
import com.izforge.izpack.util.os.WinSetupFileQueue;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public class FileQueueMove
extends FileQueueCopy {
    private static final Logger logger = Logger.getLogger(FileQueueMove.class.getName());

    public FileQueueMove(File fromFile, File toFile) {
        this(fromFile, toFile, false);
    }

    public FileQueueMove(File fromFile, File toFile, boolean forceInUse) {
        super(fromFile, toFile, true, forceInUse);
    }

    @Override
    public void addTo(WinSetupFileQueue filequeue) throws IOException {
        try {
            logger.fine("Enqueueing moving " + this.fromFile + " to " + this.toFile + " (0x" + Integer.toHexString(this.copyStyle) + ")");
            filequeue.addMove(this.fromFile, this.toFile);
        }
        catch (IOException e2) {
            throw new IOException("Failed to enqueue moving " + this.fromFile + " to " + this.toFile + " due to " + e2.getMessage());
        }
    }
}

