/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.file.types.selectors;

import com.izforge.izpack.util.file.types.Resource;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;

public final class SelectorUtils {
    private static SelectorUtils instance = new SelectorUtils();

    private SelectorUtils() {
    }

    public static SelectorUtils getInstance() {
        return instance;
    }

    public static boolean matchPatternStart(String pattern, String str) {
        return SelectorUtils.matchPatternStart(pattern, str, true);
    }

    public static boolean matchPatternStart(String pattern, String str, boolean isCaseSensitive) {
        String patDir;
        int strIdxStart;
        if (str.startsWith(File.separator) != pattern.startsWith(File.separator)) {
            return false;
        }
        String[] patDirs = SelectorUtils.tokenizePathAsArray(pattern);
        String[] strDirs = SelectorUtils.tokenizePathAsArray(str);
        int patIdxStart = 0;
        int patIdxEnd = patDirs.length - 1;
        int strIdxEnd = strDirs.length - 1;
        for (strIdxStart = 0; patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = patDirs[patIdxStart]).equals("**"); ++patIdxStart, ++strIdxStart) {
            if (SelectorUtils.match(patDir, strDirs[strIdxStart], isCaseSensitive)) continue;
            return false;
        }
        if (strIdxStart > strIdxEnd) {
            return true;
        }
        return patIdxStart <= patIdxEnd;
    }

    public static boolean matchPath(String pattern, String str) {
        return SelectorUtils.matchPath(pattern, str, true);
    }

    public static boolean matchPath(String pattern, String str, boolean isCaseSensitive) {
        String patDir;
        int strIdxStart;
        if (str.startsWith(File.separator) != pattern.startsWith(File.separator)) {
            return false;
        }
        String[] patDirs = SelectorUtils.tokenizePathAsArray(pattern);
        String[] strDirs = SelectorUtils.tokenizePathAsArray(str);
        int patIdxStart = 0;
        int patIdxEnd = patDirs.length - 1;
        int strIdxEnd = strDirs.length - 1;
        for (strIdxStart = 0; patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = patDirs[patIdxStart]).equals("**"); ++patIdxStart, ++strIdxStart) {
            if (SelectorUtils.match(patDir, strDirs[strIdxStart], isCaseSensitive)) continue;
            patDirs = null;
            strDirs = null;
            return false;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i2 = patIdxStart; i2 <= patIdxEnd; ++i2) {
                if (patDirs[i2].equals("**")) continue;
                patDirs = null;
                strDirs = null;
                return false;
            }
            return true;
        }
        if (patIdxStart > patIdxEnd) {
            patDirs = null;
            strDirs = null;
            return false;
        }
        while (patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = patDirs[patIdxEnd]).equals("**")) {
            if (!SelectorUtils.match(patDir, strDirs[strIdxEnd], isCaseSensitive)) {
                patDirs = null;
                strDirs = null;
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i3 = patIdxStart; i3 <= patIdxEnd; ++i3) {
                if (patDirs[i3].equals("**")) continue;
                patDirs = null;
                strDirs = null;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i4 = patIdxStart + 1; i4 <= patIdxEnd; ++i4) {
                if (!patDirs[i4].equals("**")) continue;
                patIdxTmp = i4;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i5 = 0; i5 <= strLength - patLength; ++i5) {
                for (int j2 = 0; j2 < patLength; ++j2) {
                    String subPat = patDirs[patIdxStart + j2 + 1];
                    String subStr = strDirs[strIdxStart + i5 + j2];
                    if (!SelectorUtils.match(subPat, subStr, isCaseSensitive)) continue block6;
                }
                foundIdx = strIdxStart + i5;
                break;
            }
            if (foundIdx == -1) {
                patDirs = null;
                strDirs = null;
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (int i6 = patIdxStart; i6 <= patIdxEnd; ++i6) {
            if (patDirs[i6].equals("**")) continue;
            patDirs = null;
            strDirs = null;
            return false;
        }
        return true;
    }

    public static boolean match(String pattern, String str) {
        return SelectorUtils.match(pattern, str, true);
    }

    public static boolean match(String pattern, String str, boolean isCaseSensitive) {
        char ch;
        int i2;
        char[] patArr = pattern.toCharArray();
        char[] strArr = str.toCharArray();
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        boolean containsStar = false;
        for (i2 = 0; i2 < patArr.length; ++i2) {
            if (patArr[i2] != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (i2 = 0; i2 <= patIdxEnd; ++i2) {
                char ch2 = patArr[i2];
                if (ch2 == '?') continue;
                if (isCaseSensitive && ch2 != strArr[i2]) {
                    return false;
                }
                if (isCaseSensitive || Character.toUpperCase(ch2) == Character.toUpperCase(strArr[i2])) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?') {
                if (isCaseSensitive && ch != strArr[strIdxStart]) {
                    return false;
                }
                if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart])) {
                    return false;
                }
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            for (i2 = patIdxStart; i2 <= patIdxEnd; ++i2) {
                if (patArr[i2] == '*') continue;
                return false;
            }
            return true;
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?') {
                if (isCaseSensitive && ch != strArr[strIdxEnd]) {
                    return false;
                }
                if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxEnd])) {
                    return false;
                }
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (i2 = patIdxStart; i2 <= patIdxEnd; ++i2) {
                if (patArr[i2] == '*') continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i3 = patIdxStart + 1; i3 <= patIdxEnd; ++i3) {
                if (patArr[i3] != '*') continue;
                patIdxTmp = i3;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block8: for (int i4 = 0; i4 <= strLength - patLength; ++i4) {
                for (int j2 = 0; j2 < patLength; ++j2) {
                    ch = patArr[patIdxStart + j2 + 1];
                    if (ch != '?' && (isCaseSensitive && ch != strArr[strIdxStart + i4 + j2] || !isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart + i4 + j2]))) continue block8;
                }
                foundIdx = strIdxStart + i4;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (i2 = patIdxStart; i2 <= patIdxEnd; ++i2) {
            if (patArr[i2] == '*') continue;
            return false;
        }
        return true;
    }

    public static Vector<String> tokenizePath(String path) {
        return SelectorUtils.tokenizePath(path, File.separator);
    }

    public static Vector<String> tokenizePath(String path, String separator) {
        Vector<String> ret = new Vector<String>();
        StringTokenizer st = new StringTokenizer(path, separator);
        while (st.hasMoreTokens()) {
            ret.addElement(st.nextToken());
        }
        return ret;
    }

    private static String[] tokenizePathAsArray(String path) {
        char sep = File.separatorChar;
        int start = 0;
        int len = path.length();
        int count = 0;
        for (int pos = 0; pos < len; ++pos) {
            if (path.charAt(pos) != sep) continue;
            if (pos != start) {
                ++count;
            }
            start = pos + 1;
        }
        if (len != start) {
            ++count;
        }
        String[] l2 = new String[count];
        count = 0;
        start = 0;
        for (int pos = 0; pos < len; ++pos) {
            if (path.charAt(pos) != sep) continue;
            if (pos != start) {
                String tok = path.substring(start, pos);
                l2[count++] = tok;
            }
            start = pos + 1;
        }
        if (len != start) {
            String tok;
            l2[count] = tok = path.substring(start);
        }
        return l2;
    }

    public static boolean isOutOfDate(File src, File target, int granularity) {
        if (!src.exists()) {
            return false;
        }
        if (!target.exists()) {
            return true;
        }
        return src.lastModified() - (long)granularity > target.lastModified();
    }

    public static boolean isOutOfDate(Resource src, Resource target, int granularity) {
        if (!src.isExists()) {
            return false;
        }
        if (!target.isExists()) {
            return true;
        }
        return src.getLastModified() - (long)granularity > target.getLastModified();
    }

    public static String removeWhitespace(String input) {
        StringBuffer result = new StringBuffer();
        if (input != null) {
            StringTokenizer st = new StringTokenizer(input);
            while (st.hasMoreTokens()) {
                result.append(st.nextToken());
            }
        }
        return result.toString();
    }

    public static boolean hasWildcards(String input) {
        return input.indexOf(42) != -1 || input.indexOf(63) != -1;
    }

    public static String rtrimWildcardTokens(String input) {
        Vector<String> v2 = SelectorUtils.tokenizePath(input, File.separator);
        StringBuffer sb = new StringBuffer();
        for (int counter = 0; counter < v2.size() && !SelectorUtils.hasWildcards(v2.elementAt(counter)); ++counter) {
            if (counter > 0) {
                sb.append(File.separator);
            }
            sb.append(v2.elementAt(counter));
        }
        return sb.toString();
    }
}

