/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.file;

import com.izforge.izpack.util.OsVersion;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;

public class FileUtils {
    public static final long FAT_FILE_TIMESTAMP_GRANULARITY = 2000L;
    public static final long UNIX_FILE_TIMESTAMP_GRANULARITY = 1000L;

    public static void copyFile(String sourceFile, String destFile, boolean overwrite, boolean preserveLastModified) throws IOException {
        FileUtils.copyFile(new File(sourceFile), new File(destFile), overwrite, preserveLastModified);
    }

    public static void copyFile(File sourceFile, File destFile, boolean overwrite, boolean preserveLastModified) throws IOException {
        if (overwrite || !destFile.exists() || destFile.lastModified() < sourceFile.lastModified()) {
            org.apache.commons.io.FileUtils.copyFile(sourceFile, destFile, preserveLastModified);
        }
    }

    public static File resolveFile(File file, String filename) throws Exception {
        return new File(FilenameUtils.concat(file == null ? null : file.getPath(), filename));
    }

    public static File getParentFile(File f2) {
        return f2 == null ? null : f2.getParentFile();
    }

    public static boolean isSymbolicLink(File parent, String name) throws IOException {
        if (parent == null) {
            File f2 = new File(name);
            parent = f2.getParentFile();
            name = f2.getName();
        }
        File toTest = new File(parent.getCanonicalPath(), name);
        return org.apache.commons.io.FileUtils.isSymlink(toTest);
    }

    public static String removeLeadingPath(File leading, File path) throws Exception {
        String p2;
        String l2 = FilenameUtils.normalize(leading.getAbsolutePath());
        if (l2.equals(p2 = FilenameUtils.normalize(path.getAbsolutePath()))) {
            return "";
        }
        if (!l2.endsWith(File.separator)) {
            l2 = l2 + File.separator;
        }
        return p2.startsWith(l2) ? p2.substring(l2.length()) : p2;
    }

    public static long getFileTimestampGranularity() {
        return OsVersion.IS_WINDOWS ? 2000L : 1000L;
    }

    public static File createTempDirectory(String prefix, File directory) throws IOException {
        File tempFile = File.createTempFile(prefix, "", directory);
        tempFile.delete();
        File tempDirectory = new File(tempFile.getPath() + ".tmp");
        if (!tempDirectory.mkdirs()) {
            throw new IOException("Failed to create temporary directory: " + tempDirectory);
        }
        return tempDirectory;
    }
}

