/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.config;

import com.izforge.izpack.util.config.ConfigurableTask;
import com.izforge.izpack.util.file.FileCopyTask;
import com.izforge.izpack.util.file.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Logger;

public abstract class ConfigurableFileCopyTask
extends FileCopyTask
implements ConfigurableTask {
    private static final Logger logger = Logger.getLogger(ConfigurableFileCopyTask.class.getName());
    private boolean patchPreserveEntries = true;
    private boolean patchPreserveValues = true;
    private boolean patchResolveVariables = false;
    protected boolean cleanup;

    public void setPatchPreserveEntries(boolean preserveEntries) {
        this.patchPreserveEntries = preserveEntries;
    }

    public void setPatchPreserveValues(boolean preserveValues) {
        this.patchPreserveValues = preserveValues;
    }

    public void setPatchResolveExpressions(boolean resolve) {
        this.patchResolveVariables = resolve;
    }

    public void setCleanup(boolean cleanup) {
        this.cleanup = cleanup;
    }

    protected abstract void doFileOperation(File var1, File var2, File var3, boolean var4, boolean var5, boolean var6) throws Exception;

    @Override
    protected void doFileOperations() throws Exception {
        if (this.fileCopyMap.size() > 0) {
            logger.fine("Merge/copy " + this.fileCopyMap.size() + " file" + (this.fileCopyMap.size() == 1 ? "" : "s") + " in " + this.destDir.getAbsolutePath());
            Enumeration e2 = this.fileCopyMap.keys();
            while (e2.hasMoreElements()) {
                String[] toFiles;
                String fromFile = (String)e2.nextElement();
                for (String toFile : toFiles = (String[])this.fileCopyMap.get(fromFile)) {
                    if (fromFile.equals(toFile)) {
                        logger.warning("Skipping self-merge/copy of " + fromFile);
                        continue;
                    }
                    logger.fine("Merge/copy " + fromFile + " into " + toFile);
                    File to = new File(toFile);
                    File parent = to.getParentFile();
                    if (parent != null && !parent.exists()) {
                        parent.mkdirs();
                    }
                    if (!to.exists()) {
                        to.createNewFile();
                    }
                    File toTmp = File.createTempFile("tmp-", null, parent);
                    try {
                        File from = new File(fromFile);
                        this.doFileOperation(from, to, toTmp, this.patchPreserveEntries, this.patchPreserveValues, this.patchResolveVariables);
                        FileUtils.copyFile(toTmp, to, this.forceOverwrite, this.preserveLastModified);
                        if (!this.cleanup || !from.exists() || from.delete()) continue;
                        logger.warning("File " + from + " could not be cleant up");
                    }
                    catch (IOException be) {
                        String msg = "Failed to merge/copy " + fromFile + " into " + toFile + " due to " + be.getMessage();
                        File targetFile = new File(toFile);
                        if (targetFile.exists() && !targetFile.delete()) {
                            msg = msg + " and I couldn't delete the corrupt " + toFile;
                        }
                        throw new Exception(msg, be);
                    }
                    finally {
                        toTmp.delete();
                    }
                }
            }
        }
    }
}

