/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.util.FileUtil;
import com.izforge.izpack.util.OsVersionConstants;
import com.izforge.izpack.util.Platform;
import com.izforge.izpack.util.Platforms;
import com.izforge.izpack.util.StringConstants;
import com.izforge.izpack.util.StringTool;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class OsVersion
implements OsVersionConstants,
StringConstants {
    private static final Logger LOGGER = Logger.getLogger(OsVersion.class.getName());
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String OS_VERSION = System.getProperty("os.version");
    public static final Platform PLATFORM = new Platforms().getCurrentPlatform(OS_NAME, OS_ARCH, OS_VERSION);
    public static final boolean IS_X86 = PLATFORM.isA(Platform.Arch.X86);
    public static final boolean IS_X64 = PLATFORM.isA(Platform.Arch.X64);
    public static final boolean IS_PPC = PLATFORM.isA(Platform.Arch.PPC);
    public static final boolean IS_SPARC = PLATFORM.isA(Platform.Arch.SPARC);
    public static final boolean IS_FREEBSD = PLATFORM.isA(Platform.Name.FREEBSD);
    public static final boolean IS_LINUX = PLATFORM.isA(Platform.Name.LINUX);
    public static final boolean IS_HPUX = PLATFORM.isA(Platform.Name.HP_UX);
    public static final boolean IS_AIX = PLATFORM.isA(Platform.Name.AIX);
    public static final boolean IS_SUNOS = PLATFORM.isA(Platform.Name.SUNOS);
    public static final boolean IS_SUNOS_X86 = PLATFORM.isA(Platforms.SUNOS_X86);
    public static final boolean IS_SUNOS_SPARC = PLATFORM.isA(Platforms.SUNOS_SPARC);
    public static final boolean IS_OS2 = PLATFORM.isA(Platform.Name.OS_2);
    public static final boolean IS_MAC = PLATFORM.isA(Platform.Name.MAC);
    public static final boolean IS_OSX = PLATFORM.isA(Platform.Name.MAC_OSX);
    public static final boolean IS_WINDOWS = PLATFORM.isA(Platforms.WINDOWS);
    public static final boolean IS_WINDOWS_XP = PLATFORM.isA(Platforms.WINDOWS_XP);
    public static final boolean IS_WINDOWS_2003 = PLATFORM.isA(Platforms.WINDOWS_2003);
    public static final boolean IS_WINDOWS_VISTA = PLATFORM.isA(Platforms.WINDOWS_VISTA);
    public static final boolean IS_WINDOWS_7 = PLATFORM.isA(Platforms.WINDOWS_7);
    public static final boolean IS_UNIX = PLATFORM.isA(Platform.Name.UNIX);
    public static final boolean IS_REDHAT_LINUX = PLATFORM.isA(Platform.Name.RED_HAT_LINUX);
    public static final boolean IS_FEDORA_LINUX = PLATFORM.isA(Platform.Name.FEDORA_LINUX);
    public static final boolean IS_MANDRAKE_LINUX = PLATFORM.isA(Platform.Name.MANDRAKE_LINUX);
    public static final boolean IS_MANDRIVA_LINUX = PLATFORM.isA(Platform.Name.MANDRIVA_LINUX) || IS_MANDRAKE_LINUX;
    public static final boolean IS_SUSE_LINUX = PLATFORM.isA(Platform.Name.SUSE_LINUX);
    public static final boolean IS_DEBIAN_LINUX = PLATFORM.isA(Platform.Name.DEBIAN_LINUX);
    public static final boolean IS_UBUNTU_LINUX = PLATFORM.isA(Platform.Name.UBUNTU_LINUX);

    private static String getReleaseFileName() {
        String result = "";
        File[] etcList = new File("/etc").listFiles();
        if (etcList != null) {
            for (File etcEntry : etcList) {
                if (!etcEntry.isFile() || !etcEntry.getName().endsWith("-release")) continue;
                return etcEntry.toString();
            }
        }
        return result;
    }

    private static String getLinuxDistribution() {
        String result = null;
        if (IS_SUSE_LINUX) {
            try {
                result = "SuSE Linux\n" + StringTool.listToString(FileUtil.getFileContent(OsVersion.getReleaseFileName()));
            }
            catch (IOException iOException) {}
        } else if (IS_REDHAT_LINUX) {
            try {
                result = "RedHat Linux\n" + StringTool.listToString(FileUtil.getFileContent(OsVersion.getReleaseFileName()));
            }
            catch (IOException iOException) {}
        } else if (IS_FEDORA_LINUX) {
            try {
                result = "Fedora Linux\n" + StringTool.listToString(FileUtil.getFileContent(OsVersion.getReleaseFileName()));
            }
            catch (IOException iOException) {}
        } else if (IS_MANDRAKE_LINUX) {
            try {
                result = "Mandrake Linux\n" + StringTool.listToString(FileUtil.getFileContent(OsVersion.getReleaseFileName()));
            }
            catch (IOException iOException) {}
        } else if (IS_MANDRIVA_LINUX) {
            try {
                result = "Mandriva Linux\n" + StringTool.listToString(FileUtil.getFileContent(OsVersion.getReleaseFileName()));
            }
            catch (IOException iOException) {}
        } else if (IS_DEBIAN_LINUX) {
            try {
                result = "Debian Linux\n" + StringTool.listToString(FileUtil.getFileContent("/etc/debian_version"));
            }
            catch (IOException iOException) {}
        } else {
            try {
                result = "Unknown Linux Distribution\n" + StringTool.listToString(FileUtil.getFileContent(OsVersion.getReleaseFileName()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    public static String getOsDetails() {
        StringBuffer result = new StringBuffer();
        result.append("OS_NAME=").append(OS_NAME).append("\n");
        if (IS_UNIX) {
            if (IS_LINUX) {
                result.append(OsVersion.getLinuxDistribution()).append("\n");
            } else {
                try {
                    result.append(FileUtil.getFileContent(OsVersion.getReleaseFileName())).append("\n");
                }
                catch (IOException e2) {
                    LOGGER.log(Level.INFO, "Unable to get release file contents in 'getOsDetails'.");
                }
            }
        }
        if (IS_WINDOWS) {
            result.append(System.getProperty("os.name")).append(" ").append(System.getProperty("sun.os.patch.level", "")).append("\n");
        }
        return result.toString();
    }

    public static void main(String[] args) {
        System.out.println(OsVersion.getOsDetails());
    }
}

