/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import java.util.regex.Pattern;

public class JavaVersion {
    public static final JavaVersion CURRENT = JavaVersion.parse(System.getProperty("java.version"));
    private final String src;
    private final int feature;

    private JavaVersion(int feature, String src) {
        this.feature = feature;
        this.src = src;
    }

    public static JavaVersion parse(String versionString) {
        if (versionString == null) {
            throw new NullPointerException();
        }
        if (versionString.startsWith("1.")) {
            versionString = versionString.substring(2);
        }
        String[] split = VersionPatterns.VERSION_PARS_SEPARATORS.split(versionString, 2);
        return new JavaVersion(Integer.parseInt(split[0]), versionString);
    }

    public int feature() {
        return this.feature;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JavaVersion)) {
            return false;
        }
        JavaVersion that = (JavaVersion)obj;
        return this.src.equals(that.src);
    }

    public int hashCode() {
        return this.src.hashCode();
    }

    public String toString() {
        return this.src;
    }

    private static class VersionPatterns {
        private static final Pattern VERSION_PARS_SEPARATORS = Pattern.compile("[.+_-]+");

        private VersionPatterns() {
        }
    }
}

