/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.uninstaller.gui;

import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.GUIPrompt;
import com.izforge.izpack.gui.IconsDatabase;
import com.izforge.izpack.uninstaller.Destroyer;
import com.izforge.izpack.uninstaller.event.DestroyerListener;
import com.izforge.izpack.uninstaller.resource.InstallLog;
import com.izforge.izpack.util.Housekeeper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class UninstallerFrame
extends JFrame {
    private static final long serialVersionUID = -1844696987323012728L;
    private final IconsDatabase icons;
    private final Messages messages;
    protected JCheckBox targetDestroyCheckbox;
    private JProgressBar progressBar;
    private JButton destroyButton;
    private JButton quitButton;
    private final Color buttonsHColor = new Color(230, 230, 230);
    private final InstallLog log;
    private final Destroyer destroyer;
    private final Housekeeper housekeeper;

    public UninstallerFrame(Destroyer destroyer, InstallLog log, Housekeeper housekeeper, Messages messages) throws Exception {
        super(messages.get("uninstaller.uninstall", new Object[0]));
        this.destroyer = destroyer;
        this.log = log;
        this.housekeeper = housekeeper;
        this.messages = messages;
        this.icons = new IconsDatabase();
        this.loadIcons();
        UIManager.put("OptionPane.yesButtonText", this.messages.get("installer.yes", new Object[0]));
        UIManager.put("OptionPane.noButtonText", this.messages.get("installer.no", new Object[0]));
        UIManager.put("OptionPane.cancelButtonText", this.messages.get("installer.cancel", new Object[0]));
        UIManager.put("OptionPane.closeButtonText", messages.get("installer.close", new Object[0]));
        UIManager.put("OptionPane.showDetailsButtonText", messages.get("installer.showDetails", new Object[0]));
        UIManager.put("OptionPane.hideDetailsButtonText", messages.get("installer.hideDetails", new Object[0]));
        UIManager.put("OptionPane.copyButtonText", messages.get("installer.copy", new Object[0]));
        UIManager.put("OptionPane.sendReportButtonText", messages.get("installer.sendReport", new Object[0]));
        this.setIconImage(((ImageIcon)this.icons.get("JFrameIcon")).getImage());
        destroyer.setProgressListener(new DestroyerListener(){

            @Override
            public void startAction(String name, int steps) {
                UninstallerFrame.this.started(steps);
            }

            @Override
            public void progress(int subStep, String message) {
                UninstallerFrame.this.progress(subStep, message);
            }

            @Override
            public void stopAction() {
                UninstallerFrame.this.finished();
            }
        });
    }

    public void init(boolean displayForceOption, boolean forceOptionState) {
        this.buildGUI(displayForceOption, forceOptionState);
        this.addWindowListener(new WindowHandler());
        this.pack();
        this.centerFrame(this);
        this.setResizable(false);
        this.setVisible(true);
    }

    private void buildGUI(boolean displayForceOption, boolean forceOptionState) {
        JPanel contentPane = (JPanel)this.getContentPane();
        GridBagLayout layout = new GridBagLayout();
        contentPane.setLayout(layout);
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = new Insets(5, 5, 5, 5);
        ActionsHandler handler = new ActionsHandler();
        JPanel glassPane = (JPanel)this.getGlassPane();
        glassPane.addMouseListener(new MouseAdapter(){});
        glassPane.addMouseMotionListener(new MouseMotionAdapter(){});
        glassPane.addKeyListener(new KeyAdapter(){});
        ButtonFactory.useButtonIcons();
        ButtonFactory.useHighlightButtons();
        JLabel warningLabel = new JLabel(this.messages.get("uninstaller.warning", new Object[0]), (Icon)this.icons.get("warning"), 11);
        this.buildConstraints(gbConstraints, 0, 0, 2, 1, 1.0, 0.0);
        gbConstraints.anchor = 17;
        gbConstraints.fill = 0;
        layout.addLayoutComponent(warningLabel, gbConstraints);
        contentPane.add(warningLabel);
        this.targetDestroyCheckbox = new JCheckBox(this.messages.get("uninstaller.destroytarget", new Object[0]) + this.log.getInstallPath(), forceOptionState);
        this.buildConstraints(gbConstraints, 0, 1, 2, 1, 1.0, 0.0);
        layout.addLayoutComponent(this.targetDestroyCheckbox, gbConstraints);
        if (displayForceOption) {
            contentPane.add(this.targetDestroyCheckbox);
        }
        gbConstraints.fill = 2;
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.progressBar.setString(this.messages.get("InstallPanel.begin", new Object[0]));
        this.buildConstraints(gbConstraints, 0, 2, 2, 1, 1.0, 0.0);
        layout.addLayoutComponent(this.progressBar, gbConstraints);
        contentPane.add(this.progressBar);
        this.destroyButton = ButtonFactory.createButton(this.messages.get("uninstaller.uninstall", new Object[0]), (Icon)this.icons.get("delete"), this.buttonsHColor);
        this.destroyButton.addActionListener(handler);
        this.buildConstraints(gbConstraints, 0, 3, 1, 1, 0.5, 0.0);
        gbConstraints.fill = 0;
        gbConstraints.anchor = 17;
        layout.addLayoutComponent(this.destroyButton, gbConstraints);
        contentPane.add(this.destroyButton);
        this.quitButton = ButtonFactory.createButton(this.messages.get("installer.quit", new Object[0]), (Icon)this.icons.get("stop"), this.buttonsHColor);
        this.quitButton.addActionListener(handler);
        this.buildConstraints(gbConstraints, 1, 3, 1, 1, 0.5, 0.0);
        gbConstraints.anchor = 13;
        layout.addLayoutComponent(this.quitButton, gbConstraints);
        contentPane.add(this.quitButton);
        this.destroyer.setPrompt(new GUIPrompt(){

            @Override
            public void message(Prompt.Type type, String message) {
                super.message(type, message);
                if (type == Prompt.Type.ERROR) {
                    UninstallerFrame.this.progressBar.setString(message);
                }
            }
        });
    }

    private void centerFrame(Window frame) {
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        Dimension frameSize = frame.getSize();
        frame.setLocation(center.x - frameSize.width / 2, center.y - frameSize.height / 2 - 10);
    }

    private void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, double wx, double wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    private void loadIcons() throws Exception {
        URL url = UninstallerFrame.class.getResource("/com/izforge/izpack/img/trash.png");
        ImageIcon img = new ImageIcon(url);
        this.icons.put("delete", img);
        url = UninstallerFrame.class.getResource("/com/izforge/izpack/img/stop.png");
        img = new ImageIcon(url);
        this.icons.put("stop", img);
        url = UninstallerFrame.class.getResource("/com/izforge/izpack/img/flag.png");
        img = new ImageIcon(url);
        this.icons.put("warning", img);
        url = UninstallerFrame.class.getResource("/com/izforge/izpack/img/JFrameIcon.png");
        img = new ImageIcon(url);
        this.icons.put("JFrameIcon", img);
    }

    private void blockGUI() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.getGlassPane().setVisible(true);
        this.getGlassPane().setEnabled(true);
    }

    private void releaseGUI() {
        this.getGlassPane().setEnabled(false);
        this.getGlassPane().setVisible(false);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void started(int count) {
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(count);
        this.blockGUI();
    }

    private void progress(int pos, String message) {
        this.progressBar.setValue(pos);
        this.progressBar.setString(message);
    }

    private void finished() {
        this.progressBar.setString(this.messages.get("InstallPanel.finished", new Object[0]));
        this.targetDestroyCheckbox.setEnabled(false);
        this.destroyButton.setEnabled(false);
        this.releaseGUI();
        List<File> failedToDelete = this.destroyer.getFailedToDelete();
        if (!failedToDelete.isEmpty()) {
            StringBuilder buffer = new StringBuilder();
            for (File f2 : failedToDelete) {
                buffer.append(f2.getPath());
                buffer.append('\n');
            }
            JTextArea textArea = new JTextArea();
            textArea.setText(buffer.toString());
            textArea.setRows(10);
            textArea.setColumns(72);
            textArea.setEditable(false);
            JScrollPane pane = new JScrollPane(textArea);
            BorderLayout layout = new BorderLayout();
            layout.setHgap(8);
            JPanel panel = new JPanel(layout);
            JLabel label = new JLabel("The following files and/or directories could not be removed:");
            panel.add((Component)label, "North");
            panel.add((Component)pane, "Center");
            label = new JLabel("Directories cannot be removed if it is not empty. Administrative privileges may be required to remove files.");
            panel.add((Component)label, "South");
            JOptionPane.showMessageDialog(null, panel, "Uninstallation Warning", 2);
        }
    }

    class ActionsHandler
    implements ActionListener {
        ActionsHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            Object src = e2.getSource();
            if (src == UninstallerFrame.this.quitButton) {
                UninstallerFrame.this.housekeeper.shutDown(0);
            } else if (src == UninstallerFrame.this.destroyButton) {
                UninstallerFrame.this.destroyButton.setEnabled(false);
                UninstallerFrame.this.destroyer.setForceDelete(UninstallerFrame.this.targetDestroyCheckbox.isSelected());
                Thread thread = new Thread((Runnable)UninstallerFrame.this.destroyer, "IzPack - Destroyer");
                thread.start();
            }
        }
    }

    private final class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowClosing(WindowEvent e2) {
            UninstallerFrame.this.housekeeper.shutDown(0);
        }
    }
}

