/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.uninstaller;

import com.izforge.izpack.api.event.ProgressListener;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.uninstaller.event.UninstallerListeners;
import com.izforge.izpack.uninstaller.resource.Executables;
import com.izforge.izpack.uninstaller.resource.InstallLog;
import com.izforge.izpack.uninstaller.resource.RootScripts;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Destroyer
implements Runnable {
    private final InstallLog log;
    private final UninstallerListeners listeners;
    private final Executables executables;
    private final RootScripts rootScripts;
    private Prompt prompt;
    private ProgressListener listener;
    private boolean forceDelete;
    private List<File> failed = new ArrayList<File>();
    private static final Logger logger = Logger.getLogger(Destroyer.class.getName());

    public Destroyer(InstallLog log, UninstallerListeners listeners, Executables executables, RootScripts rootScripts, Prompt prompt) {
        this.log = log;
        this.listeners = listeners;
        this.executables = executables;
        this.rootScripts = rootScripts;
        this.prompt = prompt;
    }

    public void setPrompt(Prompt prompt) {
        this.prompt = prompt;
    }

    public void setProgressListener(ProgressListener listener) {
        this.listener = listener;
    }

    public void setForceDelete(boolean force) {
        this.forceDelete = force;
    }

    @Override
    public void run() {
        try {
            if (!this.executables.run()) {
                logger.severe("An executable has failed. Destroyer will not be run");
            } else {
                this.destroy();
            }
        }
        catch (Throwable exception) {
            if (this.listener != null) {
                this.listener.stopAction();
            }
            logger.log(Level.SEVERE, exception.getMessage(), exception);
            StringWriter trace = new StringWriter();
            exception.printStackTrace(new PrintWriter(trace));
            this.prompt.message(Prompt.Type.ERROR, "exception caught", trace.toString());
        }
    }

    public List<File> getFailedToDelete() {
        return this.failed;
    }

    private void destroy() throws Exception {
        List<File> files = this.log.getInstalled();
        int size = files.size();
        this.listeners.beforeDeletion(files, this.listener);
        if (this.listener != null) {
            this.listener.startAction("destroy", size);
        }
        for (int i2 = 0; i2 < size; ++i2) {
            File file = files.get(i2);
            this.listeners.beforeDelete(file, this.listener);
            this.delete(file);
            this.listeners.afterDelete(file, this.listener);
            if (this.listener == null) continue;
            this.listener.progress(i2, file.getAbsolutePath());
        }
        this.listeners.afterDeletion(files, this.listener);
        this.rootScripts.run();
        if (this.listener != null) {
            this.listener.progress(this.log.getInstalled().size(), "[ cleanups ]");
        }
        File installPath = new File(this.log.getInstallPath());
        this.cleanup(installPath);
        this.checkDeletion(files, installPath);
        if (this.listener != null) {
            this.listener.stopAction();
        }
    }

    private void checkDeletion(List<File> files, File installPath) {
        this.failed.clear();
        for (File f2 : files) {
            if (!f2.exists()) continue;
            this.failed.add(f2);
        }
        if (installPath.exists()) {
            this.failed.add(installPath);
        }
    }

    private void cleanup(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File child : files) {
                    this.cleanup(child);
                }
            }
            this.delete(file);
        } else if (this.forceDelete) {
            this.delete(file);
        }
    }

    private void delete(File file) {
        if (file.exists() && !file.delete()) {
            logger.info("Failed to delete: " + file);
        }
    }
}

