/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.validator;

import com.izforge.izpack.panels.userinput.processorclient.ProcessingClient;
import com.izforge.izpack.panels.userinput.validator.Validator;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PasswordKeystoreValidator
implements Validator {
    private static final Logger logger = Logger.getLogger(PasswordKeystoreValidator.class.getName());

    @Override
    public boolean validate(ProcessingClient client) {
        boolean returnValue = false;
        String[] values = client.getValues();
        try {
            String keystoreFile;
            String skipValidation = client.getConfigurationOptionValue("skipValidation");
            logger.fine("skipValidation = " + skipValidation);
            if (skipValidation != null && skipValidation.equalsIgnoreCase("true")) {
                logger.fine("Not validating keystore");
                return true;
            }
            String keystorePassword = client.getConfigurationOptionValue("keystorePassword");
            if (keystorePassword == null) {
                keystorePassword = this.getPassword(values);
                logger.fine("keystorePassword parameter null, using validator password for keystore");
            } else if (keystorePassword.equalsIgnoreCase("")) {
                keystorePassword = this.getPassword(values);
                logger.fine("keystorePassword parameter empty, using validator password for keystore");
            }
            String aliasPassword = client.getConfigurationOptionValue("aliasPassword");
            if (aliasPassword == null) {
                aliasPassword = this.getPassword(values);
                logger.fine("aliasPassword parameter null, using validator password for key");
            } else if (aliasPassword.equalsIgnoreCase("")) {
                aliasPassword = this.getPassword(values);
                logger.fine("aliasPassword parameter empty, using validator password for key");
            }
            String keystoreType = client.getConfigurationOptionValue("keystoreType");
            if (keystoreType == null) {
                keystoreType = "JKS";
            }
            logger.fine("keystoreType parameter null, using default of JKS");
            if (keystoreType.equalsIgnoreCase("")) {
                keystoreType = "JKS";
                logger.fine("keystoreType parameter empty, using default of JKS");
            }
            if ((keystoreFile = client.getConfigurationOptionValue("keystoreFile")) != null) {
                logger.fine("Attempting to open keystore: " + keystoreFile);
                assert (keystorePassword != null);
                KeyStore keyStore = this.getKeyStore(keystoreFile, keystoreType, keystorePassword.toCharArray());
                if (keyStore != null) {
                    returnValue = true;
                    logger.fine("keystore password validated");
                    String alias = client.getConfigurationOptionValue("keystoreAlias");
                    if (alias != null) {
                        returnValue = keyStore.containsAlias(alias);
                        if (returnValue) {
                            logger.fine("keystore alias '" + alias + "' found, trying to retrieve");
                            try {
                                assert (aliasPassword != null);
                                keyStore.getKey(alias, aliasPassword.toCharArray());
                                logger.fine("keystore alias '" + alias + "' validated");
                            }
                            catch (Exception e2) {
                                logger.log(Level.FINE, "keystore alias validation failed: " + e2, e2);
                                returnValue = false;
                            }
                        } else {
                            logger.fine("keystore alias '" + alias + "' not found");
                        }
                    }
                }
            } else {
                logger.fine("keystoreFile param not provided");
            }
        }
        catch (Exception e3) {
            logger.log(Level.FINE, "validate() Failed: " + e3, e3);
        }
        return returnValue;
    }

    private String getPassword(String[] values) {
        return values.length > 0 ? values[0] : null;
    }

    private KeyStore getKeyStore(String fileName, String type, char[] password) {
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance(type);
            keyStore.load(new FileInputStream(fileName), password);
        }
        catch (Exception e2) {
            System.out.println("getKeyStore() Failed: " + e2);
            keyStore = null;
        }
        return keyStore;
    }
}

