/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.gui.search;

import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.FlowLayout;
import com.izforge.izpack.gui.TwoColumnConstraints;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.panels.userinput.field.Field;
import com.izforge.izpack.panels.userinput.field.search.SearchField;
import com.izforge.izpack.panels.userinput.gui.GUIField;
import com.izforge.izpack.panels.userinput.gui.search.SearchInputField;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class GUISearchField
extends GUIField {
    private final SearchInputField searchInputField;
    private final JComboBox combo;

    public GUISearchField(SearchField field, GUIInstallData installData, InstallerFrame frame) {
        super(field);
        boolean showAutodetect;
        String filename = field.getFilename();
        String checkFilename = field.getCheckFilename();
        this.combo = new JComboBox();
        this.combo.setEditable(true);
        this.combo.setName(field.getVariable());
        for (String choice : field.getChoices()) {
            this.combo.addItem(choice);
        }
        int index = field.getSelectedIndex();
        if (index > -1) {
            this.combo.setSelectedIndex(index);
        }
        this.addDescription();
        this.addLabel();
        Messages messages = installData.getMessages();
        StringBuilder tooltip = new StringBuilder();
        if (filename != null && filename.length() > 0) {
            tooltip.append(messages.get("UserInputPanel.search.location", filename));
        }
        boolean bl = showAutodetect = checkFilename != null && checkFilename.length() > 0;
        if (showAutodetect) {
            if (tooltip.length() != 0) {
                tooltip.append("\n");
            }
            tooltip.append(messages.get("UserInputPanel.search.location.checkedfile", checkFilename));
        }
        if (tooltip.length() > 0) {
            this.combo.setToolTipText(tooltip.toString());
        }
        TwoColumnConstraints east = new TwoColumnConstraints(26);
        this.addComponent(this.combo, east);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(3));
        JButton autoDetect = ButtonFactory.createButton(messages.get("UserInputPanel.search.autodetect", new Object[0]), installData.buttonsHColor);
        autoDetect.setVisible(showAutodetect);
        autoDetect.setToolTipText(messages.get("UserInputPanel.search.autodetect.tooltip", new Object[0]));
        JButton browse = ButtonFactory.createButton(messages.get("UserInputPanel.search.browse", new Object[0]), installData.buttonsHColor);
        buttonPanel.add(autoDetect);
        buttonPanel.add(browse);
        this.addComponent(buttonPanel, new TwoColumnConstraints(27));
        this.searchInputField = new SearchInputField(field, frame, this.combo, autoDetect, browse, installData);
        this.addTooltip();
    }

    @Override
    public boolean updateField(Prompt prompt, boolean skipValidation) {
        this.getField().setValue(this.searchInputField.getResult());
        return true;
    }

    @Override
    public boolean updateView() {
        boolean result = super.updateView();
        Field field = this.getField();
        String value = field.getInitialValue();
        if (value != null) {
            this.searchInputField.setResult(value);
            result &= true;
        }
        if (value == null && (value = field.getDefaultValue()) != null) {
            this.searchInputField.setResult(value);
            result &= true;
        }
        if (value == null) {
            result &= this.searchInputField.autodetect();
        }
        return result;
    }

    @Override
    public JComponent getFirstFocusableComponent() {
        return this.combo;
    }
}

