/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.gui.rule;

import com.izforge.izpack.gui.FlowLayout;
import com.izforge.izpack.panels.userinput.field.rule.FieldLayout;
import com.izforge.izpack.panels.userinput.field.rule.FieldSpec;
import com.izforge.izpack.panels.userinput.field.rule.RuleField;
import com.izforge.izpack.panels.userinput.gui.rule.RuleTextField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class RuleInputField
extends JComponent
implements KeyListener,
FocusListener,
CaretListener {
    private static final long serialVersionUID = 3832616275124958257L;
    private final RuleField field;
    private List<JTextField> inputFields = new ArrayList<JTextField>();
    private RuleTextField activeField;
    private boolean backstep = false;

    public RuleInputField(RuleField field) {
        this.field = field;
        FlowLayout layout = new FlowLayout();
        layout.setAlignment(0);
        this.setLayout(layout);
        this.createItems();
        this.activeField = (RuleTextField)this.inputFields.get(0);
        this.activeField.grabFocus();
    }

    public List<JTextField> getInputFields() {
        return this.inputFields;
    }

    public String getText() {
        String[] values = this.getValues();
        return this.field.format(values);
    }

    public String[] getValues() {
        String[] values = new String[this.inputFields.size()];
        for (int i2 = 0; i2 < this.inputFields.size(); ++i2) {
            values[i2] = this.inputFields.get(i2).getText();
        }
        return values;
    }

    public void setValues(String[] values) {
        for (int i2 = 0; i2 < values.length; ++i2) {
            if (i2 >= this.inputFields.size()) continue;
            this.inputFields.get(i2).setText(values[i2]);
        }
    }

    private void createItems() {
        FieldLayout layout = this.field.getLayout();
        for (Object item : layout.getLayout()) {
            if (item instanceof FieldSpec) {
                FieldSpec spec = (FieldSpec)item;
                RuleTextField field = new RuleTextField(spec);
                this.inputFields.add(field);
                field.addFocusListener(this);
                field.addKeyListener(this);
                field.addCaretListener(this);
                this.add(field);
                continue;
            }
            this.add(new JLabel((String)item));
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (JTextField jTextField : this.inputFields) {
            jTextField.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
        int activeIndex;
        int caretPosition;
        if (event.getKeyCode() == 8 && (caretPosition = this.activeField.getCaretPosition()) == 0 && (activeIndex = this.inputFields.indexOf(this.activeField)) > 0) {
            this.backstep = true;
            this.activeField = (RuleTextField)this.inputFields.get(--activeIndex);
            this.activeField.grabFocus();
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void focusGained(FocusEvent event) {
        this.activeField = (RuleTextField)event.getSource();
        if (this.backstep) {
            this.activeField.setCaretPosition(this.activeField.getText().length());
            this.backstep = false;
        } else {
            this.activeField.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent event) {
    }

    @Override
    public void caretUpdate(CaretEvent event) {
        if (this.activeField != null) {
            String text = this.activeField.getText();
            int fieldSize = this.activeField.getEditLength();
            int caretPosition = this.activeField.getCaretPosition();
            int selection = this.activeField.getSelectionEnd() - this.activeField.getSelectionStart();
            if (!(this.inputFields.get(this.inputFields.size() - 1).equals(this.activeField) || this.activeField.unlimitedEdit() || text.length() != fieldSize || selection != 0 || caretPosition != fieldSize || this.backstep)) {
                this.activeField.transferFocus();
            }
        }
    }
}

