/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.gui.radio;

import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.gui.TwoColumnConstraints;
import com.izforge.izpack.panels.userinput.field.Choice;
import com.izforge.izpack.panels.userinput.field.radio.RadioField;
import com.izforge.izpack.panels.userinput.gui.GUIField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JRadioButton;

public class GUIRadioField
extends GUIField
implements ActionListener {
    private final List<RadioChoiceView> choices = new ArrayList<RadioChoiceView>();
    private ButtonGroup buttonGroup;

    public GUIRadioField(RadioField field) {
        super(field);
        TwoColumnConstraints constraints = new TwoColumnConstraints(29);
        constraints.indent = true;
        constraints.stretch = true;
        if (this.getField().getDescription() != null) {
            this.addDescription();
        }
        String variable = field.getVariable();
        this.buttonGroup = new ButtonGroup();
        int id = 1;
        for (Choice choice : field.getChoices()) {
            boolean selected;
            JRadioButton button = new JRadioButton();
            button.setName(variable + "." + id);
            ++id;
            button.setText(choice.getValue());
            button.addActionListener(this);
            button.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e2) {
                    if (e2.getStateChange() == 1) {
                        ((JRadioButton)e2.getSource()).doClick();
                    }
                }
            });
            this.buttonGroup.add(button);
            boolean bl = selected = field.getSelectedIndex() == this.buttonGroup.getButtonCount() - 1;
            if (selected) {
                button.setSelected(true);
            }
            this.choices.add(new RadioChoiceView(choice, button));
            this.addComponent(button, constraints);
        }
        this.addTooltip();
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        this.notifyUpdateListener();
    }

    @Override
    public RadioField getField() {
        return (RadioField)super.getField();
    }

    @Override
    public boolean updateField(Prompt prompt, boolean skipValidation) {
        for (RadioChoiceView view : this.choices) {
            if (!view.button.isSelected()) continue;
            RadioField field = this.getField();
            field.setValue(view.choice.getTrueValue());
            break;
        }
        return true;
    }

    @Override
    public boolean updateView() {
        String defaultValue;
        this.refreshChoices();
        boolean result = super.updateView();
        RadioField field = this.getField();
        String value = field.getInitialValue();
        if (value != null) {
            result = this.splitValue(value);
        }
        if (!result && (defaultValue = field.getDefaultValue()) != null) {
            result = this.splitValue(defaultValue);
        }
        return result;
    }

    private boolean splitValue(String value) {
        for (RadioChoiceView view : this.choices) {
            if (value.equals(view.choice.getTrueValue())) {
                view.button.setSelected(true);
                return true;
            }
            view.button.setSelected(false);
        }
        return false;
    }

    private void refreshChoices() {
        RadioField field = this.getField();
        int index = 0;
        for (RadioChoiceView radioChoiceView : this.choices) {
            String conditionId = radioChoiceView.getChoice().getConditionId();
            JRadioButton radioButton = radioChoiceView.getButton();
            if (conditionId == null || this.getInstallData().getRules().isConditionTrue(conditionId)) {
                boolean selected;
                radioButton.setVisible(true);
                boolean bl = selected = field.getSelectedIndex() == index;
                if (selected) {
                    radioButton.setSelected(true);
                }
            } else {
                radioButton.setVisible(false);
            }
            ++index;
        }
    }

    @Override
    public JComponent getFirstFocusableComponent() {
        for (RadioChoiceView radioChoiceView : this.choices) {
            JRadioButton radioButton = radioChoiceView.getButton();
            if (!radioButton.isSelected()) continue;
            return radioButton;
        }
        if (this.choices.size() > 0) {
            return this.choices.get(0).getButton();
        }
        return null;
    }

    private class RadioChoiceView {
        private Choice choice;
        private JRadioButton button;

        public RadioChoiceView(Choice choice, JRadioButton button) {
            this.choice = choice;
            this.button = button;
        }

        public Choice getChoice() {
            return this.choice;
        }

        public JRadioButton getButton() {
            return this.button;
        }
    }
}

