/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.field.rule;

import com.izforge.izpack.panels.userinput.field.ValidationStatus;
import com.izforge.izpack.panels.userinput.field.rule.FieldSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class FieldLayout {
    private final List<FieldSpec> specs = new ArrayList<FieldSpec>();
    private final List<Object> items = new ArrayList<Object>();

    public FieldLayout(String layout) {
        StringTokenizer tokenizer = new StringTokenizer(layout);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            FieldSpec spec = FieldSpec.parse(token);
            int size = this.items.size();
            if (spec != null) {
                if (size > 0 && this.items.get(size - 1) instanceof FieldSpec) {
                    this.items.add(" ");
                }
                this.specs.add(spec);
                this.items.add(spec);
                continue;
            }
            if (!this.items.isEmpty() && this.items.get(size - 1) instanceof String) {
                String last = (String)this.items.get(size - 1);
                this.items.set(size - 1, last + " " + token);
                continue;
            }
            this.items.add(token);
        }
    }

    public List<FieldSpec> getFieldSpecs() {
        return this.specs;
    }

    public List<Object> getLayout() {
        return this.items;
    }

    public ValidationStatus validate(String value) {
        String[] result = new String[this.specs.size()];
        int specIndex = 0;
        int pos = 0;
        for (int i2 = 0; i2 < this.items.size(); ++i2) {
            String field;
            int end;
            boolean last;
            Object item = this.items.get(i2);
            if (item instanceof String) {
                String separator = (String)item;
                if (value.startsWith(separator)) {
                    value = value.substring(separator.length());
                    pos += separator.length();
                    continue;
                }
                String actual = value.length() >= separator.length() ? value.substring(0, separator.length()) : value;
                return ValidationStatus.failed("Expected '" + separator + "' at character " + pos + " but got '" + actual + "'");
            }
            FieldSpec spec = (FieldSpec)item;
            String terminator = this.getTerminator(this.items, i2);
            boolean bl = last = i2 == this.items.size() - 1;
            if (!last && terminator == null) {
                return ValidationStatus.failed("Cannot determine field delimiter at character " + pos);
            }
            int n2 = end = last ? -1 : value.indexOf(terminator);
            if (end != -1) {
                field = value.substring(0, end);
                value = value.substring(end);
            } else {
                field = value;
                value = "";
            }
            if (end == -1 && !last) {
                return ValidationStatus.failed("Unterminated field at character " + pos + ": " + field);
            }
            if (!spec.isUnlimitedLength() && field.length() > spec.getLength()) {
                return ValidationStatus.failed("Field too long at character " + pos + ". Expected length " + spec.getLength() + " but got length " + field.length() + ": " + field);
            }
            if (!spec.validate(field)) {
                return ValidationStatus.failed("Invalid field at character " + pos + ": " + field);
            }
            result[specIndex++] = field;
            pos += field.length();
        }
        return ValidationStatus.success(result);
    }

    private String getTerminator(List<Object> items, int index) {
        if (index < items.size() - 1 && items.get(index + 1) instanceof String) {
            return (String)items.get(index + 1);
        }
        return null;
    }
}

