/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.field.button;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.panels.userinput.action.ButtonAction;
import com.izforge.izpack.panels.userinput.field.Config;
import com.izforge.izpack.panels.userinput.field.SimpleFieldReader;
import com.izforge.izpack.panels.userinput.field.button.ButtonFieldConfig;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ButtonFieldReader
extends SimpleFieldReader
implements ButtonFieldConfig {
    private final Messages messages;
    private final InstallData installData;
    public static final String SPEC_SUCCESSMSG_ATTR = "successMsg";
    public static final String RUN_ELEMENT = "run";
    public static final String RUN_ELEMENT_CLASS_ATTR = "class";
    public static final String RUN_MSG_ELEMENT = "msg";
    public static final String RUN_MSG_ELEMENT_ID_ATTR = "id";
    public static final String RUN_MSG_ELEMENT_NAME_ATTR = "name";

    public ButtonFieldReader(IXMLElement field, Config config, InstallData installData) {
        super(field, config);
        this.installData = installData;
        this.messages = installData.getMessages();
    }

    @Override
    protected IXMLElement getSpec(IXMLElement field, Config config) {
        return config.getElement(field, "spec");
    }

    @Override
    public String getLabel() {
        return this.getText(this.getField());
    }

    @Override
    public String getButtonName() {
        return this.getText(this.getSpec());
    }

    @Override
    public String getSuccessMsg() {
        String successMsg = this.getSpec().getAttribute(SPEC_SUCCESSMSG_ATTR);
        if (successMsg == null) {
            successMsg = "";
        }
        return this.messages.get(successMsg, new Object[0]);
    }

    @Override
    public List<ButtonAction> getButtonActions() {
        ArrayList<ButtonAction> buttonActions = new ArrayList<ButtonAction>();
        for (IXMLElement runSpec : this.getSpec().getChildrenNamed(RUN_ELEMENT)) {
            HashMap<String, String> buttonMessages = new HashMap<String, String>();
            String actionClass = runSpec.getAttribute(RUN_ELEMENT_CLASS_ATTR);
            try {
                Class<?> buttonActionClass = Class.forName(actionClass);
                Constructor<?> buttonActionConstructor = buttonActionClass.getConstructor(InstallData.class);
                ButtonAction buttonAction = (ButtonAction)buttonActionConstructor.newInstance(this.installData);
                for (IXMLElement message : runSpec.getChildrenNamed(RUN_MSG_ELEMENT)) {
                    String id = message.getAttribute(RUN_MSG_ELEMENT_ID_ATTR);
                    String name = message.getAttribute(RUN_MSG_ELEMENT_NAME_ATTR);
                    String value = this.messages.get(id, new Object[0]);
                    buttonMessages.put(name, value);
                }
                buttonAction.setMessages(buttonMessages);
                buttonActions.add(buttonAction);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return buttonActions;
    }
}

