/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.console;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.panels.userinput.FieldCommand;
import com.izforge.izpack.panels.userinput.console.ConsoleField;
import com.izforge.izpack.panels.userinput.console.button.ConsoleButtonField;
import com.izforge.izpack.panels.userinput.console.check.ConsoleCheckField;
import com.izforge.izpack.panels.userinput.console.combo.ConsoleComboField;
import com.izforge.izpack.panels.userinput.console.custom.ConsoleCustomField;
import com.izforge.izpack.panels.userinput.console.divider.ConsoleDividerField;
import com.izforge.izpack.panels.userinput.console.file.ConsoleDirField;
import com.izforge.izpack.panels.userinput.console.file.ConsoleFileField;
import com.izforge.izpack.panels.userinput.console.password.ConsolePasswordGroupField;
import com.izforge.izpack.panels.userinput.console.radio.ConsoleRadioField;
import com.izforge.izpack.panels.userinput.console.rule.ConsoleRuleField;
import com.izforge.izpack.panels.userinput.console.search.ConsoleSearchField;
import com.izforge.izpack.panels.userinput.console.spacer.ConsoleSpacerField;
import com.izforge.izpack.panels.userinput.console.staticText.ConsoleStaticText;
import com.izforge.izpack.panels.userinput.console.text.ConsoleTextArea;
import com.izforge.izpack.panels.userinput.console.text.ConsoleTextField;
import com.izforge.izpack.panels.userinput.console.title.ConsoleTitleField;
import com.izforge.izpack.panels.userinput.field.Field;
import com.izforge.izpack.panels.userinput.field.UserInputPanelSpec;
import com.izforge.izpack.panels.userinput.field.button.ButtonField;
import com.izforge.izpack.panels.userinput.field.check.CheckField;
import com.izforge.izpack.panels.userinput.field.combo.ComboField;
import com.izforge.izpack.panels.userinput.field.custom.CustomField;
import com.izforge.izpack.panels.userinput.field.divider.Divider;
import com.izforge.izpack.panels.userinput.field.file.DirField;
import com.izforge.izpack.panels.userinput.field.file.FileField;
import com.izforge.izpack.panels.userinput.field.password.PasswordGroupField;
import com.izforge.izpack.panels.userinput.field.radio.RadioField;
import com.izforge.izpack.panels.userinput.field.rule.RuleField;
import com.izforge.izpack.panels.userinput.field.search.SearchField;
import com.izforge.izpack.panels.userinput.field.space.Spacer;
import com.izforge.izpack.panels.userinput.field.statictext.StaticText;
import com.izforge.izpack.panels.userinput.field.text.TextArea;
import com.izforge.izpack.panels.userinput.field.text.TextField;
import com.izforge.izpack.panels.userinput.field.title.TitleField;
import com.izforge.izpack.util.Console;

public class ConsoleFieldFactory {
    private final Console console;
    private final Prompt prompt;

    public ConsoleFieldFactory(Console console, Prompt prompt) {
        this.console = console;
        this.prompt = prompt;
    }

    public ConsoleField create(Field field, UserInputPanelSpec userInputPanelSpec, IXMLElement spec) {
        ConsoleField result;
        if (field instanceof CheckField) {
            result = new ConsoleCheckField((CheckField)field, this.console, this.prompt);
        } else if (field instanceof ComboField) {
            result = new ConsoleComboField((ComboField)field, this.console, this.prompt);
        } else if (field instanceof Divider) {
            result = new ConsoleDividerField(field, this.console, this.prompt);
        } else if (field instanceof DirField) {
            result = new ConsoleDirField((DirField)field, this.console, this.prompt);
        } else if (field instanceof FileField) {
            result = new ConsoleFileField((FileField)field, this.console, this.prompt);
        } else if (field instanceof PasswordGroupField) {
            result = new ConsolePasswordGroupField((PasswordGroupField)field, this.console, this.prompt);
        } else if (field instanceof RadioField) {
            result = new ConsoleRadioField((RadioField)field, this.console, this.prompt);
        } else if (field instanceof RuleField) {
            result = new ConsoleRuleField((RuleField)field, this.console, this.prompt);
        } else if (field instanceof Spacer) {
            result = new ConsoleSpacerField(field, this.console, this.prompt);
        } else if (field instanceof StaticText) {
            result = new ConsoleStaticText(field, this.console, this.prompt);
        } else if (field instanceof TextField) {
            result = new ConsoleTextField((TextField)field, this.console, this.prompt);
        } else if (field instanceof TextArea) {
            result = new ConsoleTextArea((TextArea)field, this.console, this.prompt);
        } else if (field instanceof TitleField) {
            result = new ConsoleTitleField(field, this.console, this.prompt);
        } else if (field instanceof SearchField) {
            result = new ConsoleSearchField((SearchField)field, this.console, this.prompt);
        } else if (field instanceof ButtonField) {
            result = new ConsoleButtonField((ButtonField)field, this.console, this.prompt);
        } else if (field instanceof CustomField) {
            result = new ConsoleCustomField((CustomField)field, this.console, this.prompt, new createFieldCommand(userInputPanelSpec, spec), userInputPanelSpec, spec);
        } else {
            throw new IzPackException("Unsupported field type: " + field.getClass().getName());
        }
        return result;
    }

    private class createFieldCommand
    extends FieldCommand {
        private final UserInputPanelSpec userInputPanelSpec;
        private final IXMLElement spec;

        public createFieldCommand(UserInputPanelSpec userInputPanelSpec, IXMLElement spec) {
            this.userInputPanelSpec = userInputPanelSpec;
            this.spec = spec;
        }

        @Override
        public ConsoleField createConsoleField(Field field) {
            return ConsoleFieldFactory.this.create(field, this.userInputPanelSpec, this.spec);
        }
    }
}

