/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.shortcut;

import com.izforge.izpack.api.GuiId;
import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.MultiLineLabel;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.installer.event.InstallerListeners;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.panels.shortcut.ShortcutPanelAutomationHelper;
import com.izforge.izpack.panels.shortcut.ShortcutPanelLogic;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.Platform;
import com.izforge.izpack.util.PlatformModelMatcher;
import com.izforge.izpack.util.TargetFactory;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ShortcutPanel
extends IzPanel
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 3256722870838112311L;
    private static final String TEXT_FILE_NAME = "Shortcuts.txt";
    private boolean skipPanel;
    private boolean isRootUser;
    private JList groupList;
    private JTextField programGroup;
    private JButton defaultButton;
    private JButton saveButton;
    private JCheckBox allowDesktopShortcut;
    private JCheckBox allowStartupShortcut;
    private JCheckBox allowMenuShortcut;
    private JPanel usersPanel;
    private JLabel listLabel;
    private JRadioButton currentUser;
    private JRadioButton allUsers;
    private GridBagLayout layout = (GridBagLayout)super.getLayout();
    private GridBagConstraints constraints;
    private ShortcutPanelLogic shortcutPanelLogic;
    private static final Logger logger = Logger.getLogger(ShortcutPanel.class.getName());

    public ShortcutPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, UninstallData uninstallData, Housekeeper housekeeper, TargetFactory factory, InstallerListeners listeners, PlatformModelMatcher matcher) {
        super(panel, parent, installData, "link16x16", resources);
        Object con = this.getLayoutHelper().getDefaultConstraints();
        this.constraints = con instanceof GridBagConstraints ? (GridBagConstraints)con : new GridBagConstraints();
        this.setLayout(super.getLayout());
        try {
            this.shortcutPanelLogic = new ShortcutPanelLogic(installData, resources, uninstallData, housekeeper, factory, listeners, matcher);
            this.shortcutPanelLogic.refreshShortcutData();
            if (this.shortcutPanelLogic.isSupported()) {
                this.isRootUser = this.shortcutPanelLogic.initUserType();
                this.buildUI(this.shortcutPanelLogic.getProgramsFolder(this.shortcutPanelLogic.getUserType()));
            } else if (!this.shortcutPanelLogic.skipIfNotSupported()) {
                this.buildAlternateUI();
            }
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Failed to initialise shortcuts: " + exception.getMessage(), exception);
        }
    }

    @Override
    public void panelDeactivate() {
        if (this.shortcutPanelLogic.isPreviousDisabled()) {
            this.parent.unlockPrevButton();
        }
    }

    @Override
    public void panelActivate() {
        try {
            this.shortcutPanelLogic.refreshShortcutData();
            if (this.shortcutPanelLogic.isPreviousDisabled()) {
                this.parent.lockPrevButton();
            }
            this.allowDesktopShortcut.setVisible(this.shortcutPanelLogic.hasDesktopShortcuts());
            this.allowStartupShortcut.setVisible(this.shortcutPanelLogic.hasStartupShortcuts());
            this.usersPanel.setVisible(this.shortcutPanelLogic.isSupportingMultipleUsers());
            String suggestedProgramGroup = this.shortcutPanelLogic.getSuggestedProgramGroup();
            if (suggestedProgramGroup == null || suggestedProgramGroup.isEmpty()) {
                if (this.groupList != null && !this.shortcutPanelLogic.allowProgramGroup()) {
                    this.groupList.setListData(this.shortcutPanelLogic.getDefaultGroup());
                }
                this.programGroup.setVisible(false);
                this.defaultButton.setVisible(false);
                this.listLabel.setVisible(false);
            } else if (this.programGroup.getText().isEmpty()) {
                this.programGroup.setText(suggestedProgramGroup);
            }
            if (this.groupList != null && this.groupList.getSelectedIndex() < 0) {
                this.groupList.setSelectedIndex(0);
            }
        }
        catch (Exception e2) {
            this.skipPanel = true;
            this.parent.skipPanel();
        }
    }

    @Override
    public boolean isValidated() {
        if (this.skipPanel) {
            return true;
        }
        String errorMessage = this.shortcutPanelLogic.verifyProgramGroup(this.programGroup.getText());
        if (!errorMessage.isEmpty()) {
            this.emitError("Error", errorMessage);
            return false;
        }
        this.shortcutPanelLogic.setGroupName(this.programGroup.getText());
        if (this.allowDesktopShortcut != null) {
            this.shortcutPanelLogic.setCreateDesktopShortcuts(this.allowDesktopShortcut.isSelected());
        }
        if (this.allowStartupShortcut != null) {
            this.shortcutPanelLogic.setCreateStartupShortcuts(this.allowStartupShortcut.isSelected());
        }
        this.shortcutPanelLogic.setCreateMenuShortcuts(this.allowMenuShortcut.isSelected());
        if (this.shortcutPanelLogic.isCreateShortcutsImmediately()) {
            this.shortcutPanelLogic.createAndRegisterShortcuts();
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object eventSource = event.getSource();
        if (eventSource.equals(this.currentUser) || eventSource.equals(this.allUsers)) {
            int userType = 1;
            userType = 1;
            if (eventSource.equals(this.allUsers)) {
                userType = 2;
            }
            if (this.groupList != null && this.shortcutPanelLogic.allowProgramGroup()) {
                this.groupList.setListData(this.shortcutPanelLogic.getProgramGroups(userType).toArray());
                this.groupList.setSelectedIndex(0);
            }
            this.programGroup.setText(this.shortcutPanelLogic.getSuggestedProgramGroup());
            this.shortcutPanelLogic.setUserType(userType);
        } else if (eventSource.equals(this.defaultButton)) {
            if (this.groupList != null && this.groupList.getSelectionModel() != null) {
                this.groupList.setSelectedIndex(0);
            }
            this.programGroup.setText(this.shortcutPanelLogic.getSuggestedProgramGroup());
        } else if (eventSource.equals(this.saveButton)) {
            this.saveToFile();
        } else if (eventSource.equals(this.allowMenuShortcut)) {
            boolean create = this.allowMenuShortcut.isSelected();
            if (this.groupList != null) {
                this.groupList.setEnabled(create);
                this.groupList.getSelectionModel().clearSelection();
                if (create) {
                    this.groupList.setSelectedIndex(0);
                }
            }
            this.programGroup.setEnabled(create);
            this.currentUser.setEnabled(create);
            this.defaultButton.setEnabled(create);
            if (this.isRootUser) {
                this.allUsers.setEnabled(create);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (this.programGroup == null) {
            return;
        }
        String value = "";
        try {
            value = (String)this.groupList.getSelectedValue();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (value == null || this.groupList.getSelectedIndex() == 0) {
            this.programGroup.setText(this.shortcutPanelLogic.getSuggestedProgramGroup());
        } else {
            this.programGroup.setText(value + File.separator + this.shortcutPanelLogic.getSuggestedProgramGroup());
        }
    }

    private void saveToFile() {
        JFileChooser fileDialog = new JFileChooser(this.installData.getInstallPath());
        fileDialog.setSelectedFile(new File(TEXT_FILE_NAME));
        if (fileDialog.showSaveDialog(this) == 0) {
            File file = fileDialog.getSelectedFile();
            this.shortcutPanelLogic.saveToFile(file);
        }
    }

    private void buildUI(File programsFolder) {
        int line = 0;
        int col = 0;
        this.constraints.insets = new Insets(10, 10, 0, 0);
        this.allowMenuShortcut = new JCheckBox(this.shortcutPanelLogic.getCreateShortcutsPrompt(), true);
        this.allowMenuShortcut.setName(GuiId.SHORTCUT_CREATE_CHECK_BOX.id);
        this.allowMenuShortcut.addActionListener(this);
        this.constraints.gridx = col;
        this.constraints.gridy = line + 1;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.fill = 2;
        this.constraints.anchor = 18;
        this.layout.addLayoutComponent(this.allowMenuShortcut, this.constraints);
        this.add(this.allowMenuShortcut);
        this.constraints.insets = new Insets(0, 10, 0, 0);
        boolean initialAllowedFlag = this.shortcutPanelLogic.isDesktopShortcutCheckboxSelected();
        this.allowDesktopShortcut = new JCheckBox(this.shortcutPanelLogic.getCreateDesktopShortcutsPrompt(), initialAllowedFlag);
        this.allowDesktopShortcut.setVisible(false);
        this.constraints.gridx = col;
        this.constraints.gridy = line + 2;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.layout.addLayoutComponent(this.allowDesktopShortcut, this.constraints);
        this.add(this.allowDesktopShortcut);
        boolean defaultStartupValue = this.shortcutPanelLogic.isStartupShortcutCheckboxSelected();
        this.allowStartupShortcut = new JCheckBox(this.shortcutPanelLogic.getCreateStartupShortcutsPrompt(), defaultStartupValue);
        this.allowStartupShortcut.setVisible(false);
        this.constraints.gridx = col;
        this.constraints.gridy = line + 3;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.layout.addLayoutComponent(this.allowStartupShortcut, this.constraints);
        this.add(this.allowStartupShortcut);
        this.listLabel = LabelFactory.create(this.getString("ShortcutPanel.regular.list"), 10);
        Platform platform = this.installData.getPlatform();
        this.shortcutPanelLogic.setPlatform(platform);
        if (platform.isA(Platform.Name.WINDOWS)) {
            this.constraints.gridx = col;
            this.constraints.gridy = line + 4;
            this.constraints.gridwidth = 1;
            this.constraints.gridheight = 1;
            this.constraints.insets = new Insets(10, 10, 0, 0);
            this.constraints.fill = 2;
            this.constraints.anchor = 18;
        } else {
            this.constraints.gridx = col;
            this.constraints.gridy = line + 4;
            this.constraints.gridwidth = 1;
            this.constraints.gridheight = 1;
            this.constraints.insets = new Insets(10, 10, 0, 0);
            this.constraints.fill = 2;
            this.constraints.anchor = 16;
        }
        this.layout.addLayoutComponent(this.listLabel, this.constraints);
        this.add(this.listLabel);
        Vector<String> dirEntries = new Vector<String>();
        dirEntries.add("(Default)");
        File[] entries = programsFolder.listFiles();
        if (entries != null && !platform.isA(Platform.Name.UNIX)) {
            for (File entry : entries) {
                if (!entry.isDirectory()) continue;
                dirEntries.add(entry.getName());
            }
        }
        if (platform.isA(Platform.Name.WINDOWS)) {
            if (this.groupList == null) {
                this.groupList = new JList();
            }
            this.groupList = this.addList(dirEntries, 0, this.groupList, col, line + 5, 1, 1, 1);
            this.groupList.setSelectedIndex(0);
        }
        boolean rUserFlag = !this.shortcutPanelLogic.isDefaultCurrentUserFlag() && this.isRootUser;
        this.usersPanel = new JPanel(new GridLayout(2, 1));
        ButtonGroup usersGroup = new ButtonGroup();
        this.currentUser = new JRadioButton(this.shortcutPanelLogic.getCreateForCurrentUserPrompt(), !rUserFlag);
        this.currentUser.addActionListener(this);
        usersGroup.add(this.currentUser);
        this.usersPanel.add(this.currentUser);
        this.allUsers = new JRadioButton(this.shortcutPanelLogic.getCreateForAllUsersPrompt(), rUserFlag);
        logger.fine("allUsers.setEnabled(), am I root?: " + this.isRootUser);
        this.allUsers.setEnabled(this.isRootUser);
        this.allUsers.addActionListener(this);
        usersGroup.add(this.allUsers);
        this.usersPanel.add(this.allUsers);
        TitledBorder border = new TitledBorder(new EmptyBorder(2, 2, 2, 2), this.shortcutPanelLogic.getCreateForUserPrompt());
        this.usersPanel.setBorder(border);
        if (platform.isA(Platform.Name.WINDOWS)) {
            this.constraints.gridx = col + 1;
            this.constraints.gridy = line + 5;
            this.constraints.gridwidth = 1;
            this.constraints.gridheight = 1;
        } else {
            this.constraints.insets = new Insets(10, 10, 20, 0);
            this.constraints.gridx = col;
            this.constraints.gridy = line + 5;
            this.constraints.gridwidth = 2;
            this.constraints.gridheight = 1;
            this.constraints.anchor = 13;
        }
        this.constraints.fill = 2;
        this.layout.addLayoutComponent(this.usersPanel, this.constraints);
        this.usersPanel.setVisible(false);
        this.add(this.usersPanel);
        this.programGroup = new JTextField("", 40);
        this.constraints.gridx = col;
        this.constraints.gridy = line + 6;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.fill = 2;
        this.layout.addLayoutComponent(this.programGroup, this.constraints);
        this.add(this.programGroup);
        this.defaultButton = ButtonFactory.createButton(this.getString("ShortcutPanel.regular.default"), this.installData.buttonsHColor);
        this.defaultButton.addActionListener(this);
        this.constraints.gridx = col + 1;
        this.constraints.gridy = line + 6;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.fill = 2;
        this.layout.addLayoutComponent(this.defaultButton, this.constraints);
        this.add(this.defaultButton);
    }

    private JList addList(Vector<String> Entries, int ListModel2, JList aJList, int aGridx, int aGridy, int aGridwidth, int aGridheight, int aFill) {
        if (aJList == null) {
            aJList = new JList<String>(Entries);
        } else {
            aJList.setListData(Entries);
        }
        aJList.setSelectionMode(ListModel2);
        aJList.getSelectionModel().addListSelectionListener(this);
        JScrollPane scrollPane = new JScrollPane(aJList);
        this.constraints.gridx = aGridx;
        this.constraints.gridy = aGridy;
        this.constraints.gridwidth = aGridwidth;
        this.constraints.gridheight = aGridheight;
        this.constraints.weightx = 2.0;
        this.constraints.weighty = 1.5;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.constraints.fill = aFill;
        this.layout.addLayoutComponent(scrollPane, this.constraints);
        this.add(scrollPane);
        return aJList;
    }

    private void buildAlternateUI() {
        this.layout = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.setLayout(this.layout);
        MultiLineLabel apologyLabel = new MultiLineLabel(this.getString("ShortcutPanel.alternate.apology"));
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.constraints.fill = 2;
        this.constraints.anchor = 17;
        this.layout.addLayoutComponent(apologyLabel, this.constraints);
        this.add(apologyLabel);
        MultiLineLabel listLabel = new MultiLineLabel(this.getString("ShortcutPanel.alternate.targetsLabel"));
        this.constraints.gridx = 0;
        this.constraints.gridy = 1;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.layout.addLayoutComponent(listLabel, this.constraints);
        this.add(listLabel);
        Vector<String> targets = new Vector<String>();
        if (this.shortcutPanelLogic != null) {
            targets.addAll(this.shortcutPanelLogic.getTargets());
        }
        JList targetList = new JList(targets);
        JScrollPane scrollPane = new JScrollPane(targetList);
        this.constraints.gridx = 0;
        this.constraints.gridy = 2;
        this.constraints.fill = 1;
        this.layout.addLayoutComponent(scrollPane, this.constraints);
        this.add(scrollPane);
        MultiLineLabel fileExplanation = new MultiLineLabel(this.getString("ShortcutPanel.alternate.textFileExplanation"));
        this.constraints.gridx = 0;
        this.constraints.gridy = 3;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.fill = 2;
        this.layout.addLayoutComponent(fileExplanation, this.constraints);
        this.add(fileExplanation);
        this.saveButton = ButtonFactory.createButton(this.getString("ShortcutPanel.alternate.saveButton"), this.installData.buttonsHColor);
        this.saveButton.addActionListener(this);
        this.constraints.gridx = 0;
        this.constraints.gridy = 4;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.layout.addLayoutComponent(this.saveButton, this.constraints);
        this.add(this.saveButton);
    }

    @Override
    public Dimension getSize() {
        Dimension size = this.getParent().getSize();
        Insets insets = this.getInsets();
        Border border = this.getBorder();
        Insets borderInsets = new Insets(0, 0, 0, 0);
        if (border != null) {
            borderInsets = border.getBorderInsets(this);
        }
        size.height = size.height - insets.top - insets.bottom - borderInsets.top - borderInsets.bottom - 50;
        size.width = size.width - insets.left - insets.right - borderInsets.left - borderInsets.right - 50;
        return size;
    }

    @Override
    public void createInstallationRecord(IXMLElement panelRoot) {
        try {
            new ShortcutPanelAutomationHelper(this.shortcutPanelLogic).createInstallationRecord(this.installData, panelRoot);
        }
        catch (Exception e2) {
            logger.log(Level.WARNING, "Could generate automatic installer description for shortcuts.");
        }
    }
}

