/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.panel;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLWriter;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.installer.panel.AbstractPanelView;
import com.izforge.izpack.installer.panel.PanelViews;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public abstract class AbstractPanels<T extends AbstractPanelView<V>, V>
implements PanelViews<T, V> {
    private final List<Panel> panels = new ArrayList<Panel>();
    private final List<T> panelViews;
    private final InstallData installData;
    private final Variables variables;
    private int index = -1;
    private boolean nextEnabled;
    private boolean previousEnabled;
    private static final Logger logger = Logger.getLogger(AbstractPanels.class.getName());

    public AbstractPanels(List<T> panels, InstallData installData) {
        this.panelViews = panels;
        this.installData = installData;
        this.variables = installData.getVariables();
        this.nextEnabled = !panels.isEmpty();
        int index = 0;
        for (AbstractPanelView panelView : panels) {
            panelView.setIndex(index++);
            this.panels.add(panelView.getPanel());
        }
    }

    @Override
    public List<Panel> getPanels() {
        return this.panels;
    }

    @Override
    public Panel getPanel() {
        return this.index >= 0 && this.index < this.panels.size() ? this.panels.get(this.index) : null;
    }

    @Override
    public List<T> getPanelViews() {
        return this.panelViews;
    }

    @Override
    public V getView() {
        T panelView = this.getPanelView();
        return panelView != null ? (V)((AbstractPanelView)panelView).getView() : null;
    }

    @Override
    public T getPanelView() {
        return this.getPanelView(this.index);
    }

    @Override
    public boolean isValid() {
        T panel = this.getPanelView();
        return panel == null || this.executeValidationActions(panel, true);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean hasNext() {
        return this.getNext(this.index, false) != -1;
    }

    @Override
    public boolean next() {
        return this.next(true);
    }

    @Override
    public boolean next(boolean validate) {
        int newIndex;
        boolean result = false;
        if ((!validate || this.isValid()) && (newIndex = this.getNext(this.index, false)) != -1) {
            result = this.switchPanel(newIndex, validate);
        }
        return result;
    }

    @Override
    public boolean hasPrevious() {
        return this.getPrevious(this.index, false) != -1;
    }

    @Override
    public boolean previous() {
        return this.previous(this.index);
    }

    @Override
    public boolean previous(int index) {
        int newIndex;
        boolean result = false;
        if (this.hasPrevious() && (newIndex = this.getPrevious(index, true)) != -1) {
            result = this.switchPanel(newIndex, false);
        }
        return result;
    }

    @Override
    public int getNext(int index, boolean visibleOnly) {
        int result = -1;
        List<T> panels = this.getPanelViews();
        for (int i2 = index + 1; i2 < panels.size(); ++i2) {
            if (!this.canShow((AbstractPanelView)panels.get(i2), visibleOnly)) continue;
            result = i2;
            break;
        }
        return result;
    }

    @Override
    public int getNext(boolean visibleOnly) {
        return this.getNext(this.index, visibleOnly);
    }

    @Override
    public int getPrevious(int index, boolean visibleOnly) {
        int result = -1;
        for (int i2 = index - 1; i2 >= 0; --i2) {
            if (!this.canShow(this.getPanelView(i2), visibleOnly)) continue;
            result = i2;
            break;
        }
        return result;
    }

    @Override
    public int getPrevious(boolean visibleOnly) {
        return this.getPrevious(this.index, visibleOnly);
    }

    @Override
    public int getVisibleIndex(T panel) {
        int result = -1;
        if (((AbstractPanelView)panel).isVisible()) {
            for (int i2 = 0; i2 <= ((AbstractPanelView)panel).getIndex() && i2 < this.panelViews.size(); ++i2) {
                if (!((AbstractPanelView)this.panelViews.get(i2)).isVisible()) continue;
                ++result;
            }
        }
        return result;
    }

    @Override
    public int getVisible() {
        int result = 0;
        for (AbstractPanelView panelView : this.panelViews) {
            if (!panelView.isVisible()) continue;
            ++result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeInstallationRecord(File file, UninstallData uninstallData) throws Exception {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            XMLWriter writer = new XMLWriter(out);
            IXMLElement panelsRoot = this.installData.getInstallationRecord();
            for (AbstractPanelView panelView : this.panelViews) {
                Panel panel = panelView.getPanel();
                if (!panel.isVisited()) continue;
                IXMLElement panelRoot = panelView.createPanelRootRecord();
                panelView.createInstallationRecord(panelRoot);
                panelsRoot.addChild(panelRoot);
            }
            writer.write(panelsRoot);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            if (file.getAbsolutePath().startsWith(this.installData.getInstallPath())) {
                uninstallData.addFile(file.getAbsolutePath(), true);
            }
            throw throwable;
        }
        IOUtils.closeQuietly(out);
        if (file.getAbsolutePath().startsWith(this.installData.getInstallPath())) {
            uninstallData.addFile(file.getAbsolutePath(), true);
        }
    }

    public boolean switchPanel(int newIndex, boolean validate) {
        boolean result;
        T panel = this.getPanelView();
        if (panel != null) {
            ((AbstractPanelView)panel).saveData();
        }
        if (newIndex > this.index && !this.hasNext()) {
            return false;
        }
        try {
            this.variables.refresh();
            T oldPanelView = this.getPanelView(this.index);
            T newPanelView = this.getPanelView(newIndex);
            int oldIndex = this.index;
            this.index = newIndex;
            Panel newPanel = ((AbstractPanelView)newPanelView).getPanel();
            newPanel.setVisited(true);
            if (this.switchPanel(newPanelView, oldPanelView)) {
                if (oldIndex > newIndex) {
                    for (int i2 = this.panelViews.size() - 1; i2 > this.index; --i2) {
                        AbstractPanelView futurePanelView = (AbstractPanelView)this.panelViews.get(i2);
                        Panel futurePanel = futurePanelView.getPanel();
                        futurePanel.setVisited(false);
                        Set<String> blockedNames = futurePanel.getAffectedVariableNames();
                        this.variables.unregisterBlockedVariableNames(futurePanel.getAffectedVariableNames(), futurePanel);
                        if (!logger.isLoggable(Level.FINE)) continue;
                        logger.fine("Unblocked variables on panel '" + futurePanel.getPanelId() + "': " + this.createListAsString(blockedNames));
                    }
                } else {
                    Set<String> blockedNames = newPanel.getAffectedVariableNames();
                    this.variables.registerBlockedVariableNames(blockedNames, newPanel);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Blocked variables on panel '" + newPanel.getPanelId() + "': " + this.createListAsString(blockedNames));
                    }
                }
                logger.fine("Switched panel index: " + oldIndex + " -> " + this.index);
                result = true;
            } else {
                this.index = oldIndex;
                result = false;
                newPanel.setVisited(false);
            }
            this.variables.refresh();
        }
        catch (IzPackException e2) {
            result = false;
            ((AbstractPanelView)this.getPanelView()).getHandler().emitError(null, e2.getMessage());
        }
        return result;
    }

    private String createListAsString(Set<String> list) {
        StringBuffer msg = new StringBuffer("{");
        if (list != null) {
            Iterator<String> it = list.iterator();
            while (it.hasNext()) {
                if (!logger.isLoggable(Level.FINE)) continue;
                msg.append(it.next());
                if (!it.hasNext()) continue;
                msg.append(", ");
            }
        }
        msg.append("}");
        return msg.toString();
    }

    protected abstract boolean switchPanel(T var1, T var2);

    protected boolean executeValidationActions(T panel, boolean validate) {
        boolean result;
        if (validate) {
            result = ((AbstractPanelView)panel).isValid();
        } else {
            try {
                this.variables.refresh();
                ((AbstractPanelView)panel).executePreValidationActions();
                ((AbstractPanelView)panel).executePostValidationActions();
                ((AbstractPanelView)panel).saveData();
                result = true;
            }
            catch (IzPackException e2) {
                result = false;
                ((AbstractPanelView)this.getPanelView()).getHandler().emitError(null, e2.getMessage());
            }
        }
        return result;
    }

    private T getPanelView(int index) {
        List<T> panels = this.getPanelViews();
        return (T)(index >= 0 && index < panels.size() ? (AbstractPanelView)panels.get(index) : null);
    }

    private boolean canShow(T panel, boolean visibleOnly) {
        return (!visibleOnly || ((AbstractPanelView)panel).isVisible()) && ((AbstractPanelView)panel).canShow();
    }
}

