/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.multiunpacker;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.core.io.VolumeLocator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MultiVolumeUnpackerAutomationHelper
implements VolumeLocator {
    private final InstallData installData;
    private static final Logger logger = Logger.getLogger(MultiVolumeUnpackerAutomationHelper.class.getName());

    public MultiVolumeUnpackerAutomationHelper(InstallData installData) {
        this.installData = installData;
    }

    @Override
    public File getVolume(String path, boolean corrupt) throws IOException {
        Messages messages = this.installData.getMessages();
        if (corrupt) {
            System.err.println(" [ " + messages.get("nextmedia.corruptmedia.title", new Object[0]) + " ] ");
            System.err.println(messages.get("nextmedia.corruptmedia", new Object[0]));
            System.err.println(messages.get("nextmedia.corruptmedia", new Object[0]));
        }
        logger.fine("Enter next media: " + path);
        File volume = new File(path);
        while (!volume.exists() || corrupt) {
            System.out.println(" [ " + messages.get("nextmedia.title", new Object[0]) + " ] ");
            System.out.println(messages.get("nextmedia.msg", new Object[0]));
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String nextmediainput = null;
            try {
                nextmediainput = reader.readLine();
            }
            catch (IOException e2) {
                logger.log(Level.WARNING, "Error reading next media path: " + e2.getMessage(), e2);
                e2.printStackTrace();
            }
            if (nextmediainput != null) {
                volume = new File(nextmediainput);
            } else {
                logger.fine("Input from NextMediaDialog was null");
                volume = new File(path);
            }
            if (path.equals(volume.getAbsolutePath()) && corrupt) continue;
            corrupt = false;
        }
        return volume;
    }
}

