/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.gui;

import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.installer.data.GUIInstallData;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.Timer;

public class SplashScreen {
    private static final Logger logger = Logger.getLogger(SplashScreen.class.getName());
    private final Resources resources;
    private final GUIInstallData installData;
    private JFrame frame;

    public SplashScreen(Resources resources, GUIInstallData installData) {
        this.installData = installData;
        this.resources = resources;
    }

    public void displaySplashScreen(final Object trigger) {
        if (this.installData.guiPrefs.modifier.containsKey("useSplashScreen")) {
            ImageIcon splashIcon = this.resources.getImageIcon("/resources/Splash.image", new String[0]);
            if (splashIcon != null) {
                try {
                    this.frame = new JFrame();
                    this.frame.setUndecorated(true);
                    JLabel labelSplash = new JLabel(splashIcon);
                    this.frame.getContentPane().add((Component)labelSplash, "Center");
                    this.frame.pack();
                    this.frame.setLocationRelativeTo(null);
                    this.frame.setVisible(true);
                }
                catch (Exception e2) {
                    logger.log(Level.WARNING, "Prepare and display splashScreen failed.", e2);
                }
            } else {
                logger.log(Level.WARNING, "No splash icon found!!!");
            }
            try {
                int duration = Integer.parseInt(this.installData.guiPrefs.modifier.get("useSplashScreen"));
                if (duration > 0) {
                    Timer timer = new Timer(duration, new ActionListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void actionPerformed(ActionEvent e2) {
                            Object object = trigger;
                            synchronized (object) {
                                trigger.notifyAll();
                            }
                        }
                    });
                    timer.setRepeats(false);
                    timer.start();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void removeSplashScreen() {
        if (this.frame != null) {
            this.frame.setVisible(false);
        }
    }
}

