/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.debugger;

import com.izforge.izpack.installer.debugger.VariableHistory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

public class VariableHistoryTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 5966543100431588652L;
    public static final String[] columnheader = new String[]{"Name", "Value"};
    private final List<VariableHistory> tableValues = new ArrayList<VariableHistory>();
    private final Map<String, VariableHistory> historyValues = new HashMap<String, VariableHistory>();

    @Override
    public int getColumnCount() {
        return columnheader.length;
    }

    @Override
    public int getRowCount() {
        return this.tableValues.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex > this.tableValues.size() || columnIndex < 0) {
            return null;
        }
        VariableHistory variableHistory = this.tableValues.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return variableHistory.getName();
            }
            case 1: {
                return variableHistory;
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        return columnheader[column];
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 1) {
            return VariableHistory.class;
        }
        return String.class;
    }

    public void clearState() {
        for (VariableHistory variableHistory : this.tableValues) {
            variableHistory.clearState();
        }
    }

    public void setValue(String name, String value, String comment) {
        VariableHistory variableHistory = this.historyValues.get(name);
        if (variableHistory == null) {
            variableHistory = new VariableHistory(name);
            this.historyValues.put(name, variableHistory);
        }
        if (!this.tableValues.contains(variableHistory)) {
            this.tableValues.add(variableHistory);
        }
        variableHistory.addValue(value, comment);
    }

    public void removeValue(String name, String comment) {
        VariableHistory variableHistory = this.historyValues.get(name);
        if (variableHistory == null) {
            variableHistory = new VariableHistory(name);
            this.historyValues.put(name, variableHistory);
        } else {
            this.tableValues.remove(variableHistory);
        }
        variableHistory.removeValue(comment);
    }
}

