/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.base;

import com.izforge.izpack.api.data.Info;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.util.FileUtil;
import com.izforge.izpack.util.Platform;
import com.izforge.izpack.util.PrivilegedRunner;
import javax.swing.JOptionPane;

public class InstallDataConfiguratorWithRules {
    private InstallData installData;
    private RulesEngine rules;
    private Platform platform;

    public InstallDataConfiguratorWithRules(InstallData installData, RulesEngine rules, Platform platform) {
        this.installData = installData;
        this.rules = rules;
        this.platform = platform;
    }

    public void configureInstallData() {
        this.checkForPrivilegedExecution(this.installData.getInfo());
        this.checkForRebootAction(this.installData.getInfo());
    }

    private void checkForPrivilegedExecution(Info info) {
        if (info.isPrivilegedExecutionRequired()) {
            boolean shouldElevate = true;
            String conditionId = info.getPrivilegedExecutionConditionID();
            if (conditionId != null) {
                shouldElevate = this.rules.getCondition(conditionId).isTrue();
            }
            if (shouldElevate) {
                this.elevate();
            }
        }
    }

    private void elevate() {
        PrivilegedRunner runner = new PrivilegedRunner(this.platform);
        if (runner.isPlatformSupported() && runner.isElevationNeeded()) {
            try {
                FileUtil.getLockFile(this.installData.getInfo().getAppName()).delete();
                if (runner.relaunchWithElevatedRights() != 0) {
                    throw new IzPackException("Launching an installer with elevated permissions failed.");
                }
                System.exit(0);
            }
            catch (Exception e2) {
                JOptionPane.showMessageDialog(null, "Administrative privileges required.\nPlease re-run the installer with administrative privileges.");
            }
            System.exit(0);
        } else if (!runner.isPlatformSupported()) {
            JOptionPane.showMessageDialog(null, "This installer should be run by an administrator.\nThe installation will still continue but you may encounter problems due to insufficient permissions.");
        }
    }

    private void checkForRebootAction(Info info) {
        String conditionId = info.getRebootActionConditionID();
        if (conditionId != null && !this.rules.getCondition(conditionId).isTrue()) {
            info.setRebootAction(0);
        }
    }
}

