/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui;

import com.izforge.izpack.api.handler.AbstractPrompt;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.gui.FlowLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class GUIPrompt
extends AbstractPrompt {
    private final JComponent parent;
    private static final String OK_BUTTON = "OptionPane.okButtonText";
    private static final String CANCEL_BUTTON = "OptionPane.cancelButtonText";
    private static final String YES_BUTTON = "OptionPane.yesButtonText";
    private static final String NO_BUTTON = "OptionPane.noButtonText";
    private static final String CLOSE_BUTTON = "OptionPane.closeButtonText";
    private static final String SHOW_DETAILS_BUTTON = "OptionPane.showDetailsButtonText";
    private static final String HIDE_DETAILS_BUTTON = "OptionPane.hideDetailsButtonText";
    private static final String COPY_BUTTON = "OptionPane.copyButtonText";
    private static final String SEND_REPORT_BUTTON = "OptionPane.sendReportButtonText";

    public GUIPrompt() {
        this(null);
    }

    public GUIPrompt(JComponent parent) {
        this.parent = parent;
    }

    @Override
    public void message(Prompt.Type type, String title, String message, Throwable throwable) {
        if (title == null) {
            title = this.getTitle(type);
        }
        this.showMessageDialog(this.getMessageType(type), title, message, null, throwable);
    }

    @Override
    public Prompt.Option confirm(Prompt.Type type, String title, String message, Prompt.Options options, Prompt.Option defaultOption) {
        int selected;
        int optionType;
        int messageType = this.getMessageType(type);
        switch (options) {
            case OK_CANCEL: {
                optionType = 2;
                break;
            }
            case YES_NO_CANCEL: {
                optionType = 1;
                break;
            }
            default: {
                optionType = 0;
            }
        }
        if (title == null) {
            title = this.getTitle(type);
        }
        if (defaultOption == null) {
            selected = this.showConfirmDialog(messageType, title, message, optionType);
        } else {
            String initialValue;
            ArrayList<Object> opts = new ArrayList<Object>();
            switch (optionType) {
                case 2: {
                    String ok = UIManager.getString(OK_BUTTON);
                    String cancel = UIManager.getString(CANCEL_BUTTON);
                    opts.add(ok);
                    opts.add(cancel);
                    initialValue = defaultOption == Prompt.Option.OK ? ok : (defaultOption == Prompt.Option.CANCEL ? cancel : null);
                    break;
                }
                case 0: {
                    String yes = UIManager.getString(YES_BUTTON);
                    String no = UIManager.getString(NO_BUTTON);
                    opts.add(yes);
                    opts.add(no);
                    initialValue = defaultOption == Prompt.Option.YES ? yes : (defaultOption == Prompt.Option.NO ? no : null);
                    break;
                }
                case 1: {
                    String yes = UIManager.getString(YES_BUTTON);
                    String no = UIManager.getString(NO_BUTTON);
                    opts.add(yes);
                    opts.add(no);
                    String cancel = UIManager.getString(CANCEL_BUTTON);
                    initialValue = defaultOption == Prompt.Option.YES ? yes : (defaultOption == Prompt.Option.NO ? no : (defaultOption == Prompt.Option.CANCEL ? cancel : null));
                    break;
                }
                default: {
                    initialValue = null;
                }
            }
            selected = this.showOptionDialog(messageType, title, message, optionType, opts, initialValue);
        }
        return this.getSelected(options, selected);
    }

    private int getMessageType(Prompt.Type type) {
        int result;
        switch (type) {
            case INFORMATION: {
                result = 1;
                break;
            }
            case WARNING: {
                result = 2;
                break;
            }
            case QUESTION: {
                result = 3;
                break;
            }
            default: {
                result = 0;
            }
        }
        return result;
    }

    public void showMessageDialog(final int type, final String title, final String message, final String submissionURL, final Throwable throwable) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showMessageDialog0(type, title, message, submissionURL, throwable);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        GUIPrompt.this.showMessageDialog0(type, title, message, submissionURL, throwable);
                    }
                });
            }
            catch (Exception e2) {
                throw new IllegalStateException(e2);
            }
        }
    }

    private void showMessageDialog0(int type, String title, String message, final String submissionURL, final Throwable throwable) {
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        String throwMessage = null;
        final JButton detailsButton = new JButton(UIManager.getString(SHOW_DETAILS_BUTTON));
        JButton copyButton = new JButton(UIManager.getString(COPY_BUTTON));
        if (throwable != null) {
            throwMessage = throwable.getMessage();
            buttons.add(detailsButton);
            buttons.add(copyButton);
        }
        final String basicMessage = message != null ? message : (throwMessage != null ? throwMessage : UIManager.getString("installer.errorMessage"));
        Font font = UIManager.getFont("OptionPane.font");
        AffineTransform at = new AffineTransform();
        FontRenderContext frc = new FontRenderContext(at, true, true);
        final int basicMessageWidth = (int)font.getStringBounds(basicMessage, frc).getWidth();
        JPanel topPanel = new JPanel();
        final JLabel messageLabel = new JLabel();
        messageLabel.setName("OptionPane.label");
        messageLabel.setText(basicMessage);
        if (basicMessageWidth > 700) {
            messageLabel.setText(this.wrapHtml(basicMessage));
            messageLabel.setSize(new Dimension(700, 10));
            messageLabel.setPreferredSize(new Dimension(700, messageLabel.getPreferredSize().height));
        } else {
            messageLabel.setText(basicMessage);
        }
        topPanel.add(messageLabel);
        final JPanel centerPanel = new JPanel();
        centerPanel.setSize(new Dimension(420, 300));
        final JEditorPane exceptionPane = new JEditorPane();
        exceptionPane.setEditable(false);
        exceptionPane.setContentType("text/html");
        exceptionPane.setText(GUIPrompt.getHTMLDetails(throwable));
        JScrollPane exceptionScrollPane = new JScrollPane(exceptionPane);
        exceptionScrollPane.setPreferredSize(new Dimension(470, 300));
        centerPanel.setLayout(new FlowLayout(1, 5, 5));
        centerPanel.add(exceptionScrollPane);
        centerPanel.setVisible(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)topPanel, "North");
        jPanel.add((Component)centerPanel, "Center");
        final JButton reportButton = new JButton(UIManager.getString(SEND_REPORT_BUTTON));
        if (submissionURL != null) {
            buttons.add(reportButton);
        }
        JButton closeButton = new JButton(UIManager.getString(CLOSE_BUTTON));
        buttons.add(closeButton);
        JOptionPane pane = new JOptionPane(jPanel, type, 0, null, buttons.toArray());
        final JDialog dialog = pane.createDialog(this.parent, title);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.dispose();
            }
        });
        if (throwable != null) {
            detailsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    String label = detailsButton.getText();
                    if (label.startsWith(UIManager.getString(GUIPrompt.SHOW_DETAILS_BUTTON))) {
                        if (basicMessageWidth > 700) {
                            messageLabel.setText(GUIPrompt.this.wrapHtml(basicMessage));
                        } else {
                            messageLabel.setText(basicMessage);
                        }
                        centerPanel.setVisible(true);
                        detailsButton.setText(UIManager.getString(GUIPrompt.HIDE_DETAILS_BUTTON));
                        dialog.pack();
                    } else {
                        if (basicMessageWidth > 700) {
                            messageLabel.setText(GUIPrompt.this.wrapHtml(basicMessage));
                        } else {
                            messageLabel.setText(basicMessage);
                        }
                        centerPanel.setVisible(false);
                        detailsButton.setText(UIManager.getString(GUIPrompt.SHOW_DETAILS_BUTTON));
                        dialog.pack();
                    }
                }
            });
            copyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    exceptionPane.selectAll();
                    exceptionPane.copy();
                }
            });
        }
        if (reportButton != null) {
            reportButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    try {
                        String response = GUIPrompt.reportThrowable(throwable, submissionURL);
                        messageLabel.setText("<html>Error reported to:<pre>" + submissionURL + "</pre>Server responds:<p>" + response + "</html>");
                        dialog.pack();
                        reportButton.setText("Error Reported");
                        reportButton.setEnabled(false);
                    }
                    catch (IOException e2) {
                        messageLabel.setText("Error not reported: " + e2);
                        dialog.pack();
                    }
                }
            });
        }
        dialog.setVisible(true);
    }

    private static String getHTMLDetails(Throwable throwable) {
        StringBuffer b2 = new StringBuffer("<html>");
        int lengthOfLastTrace = 1;
        while (throwable != null) {
            b2.append("<b>" + throwable.getClass().getName() + "</b>: " + throwable.getMessage() + "<ul>");
            StackTraceElement[] stack = throwable.getStackTrace();
            for (int i2 = stack.length - lengthOfLastTrace; i2 >= 0; --i2) {
                b2.append("<li> in " + stack[i2].getClassName() + ".<b>" + stack[i2].getMethodName() + "</b>() at <tt>" + stack[i2].getFileName() + ":" + stack[i2].getLineNumber() + "</tt>");
            }
            b2.append("</ul>");
            if ((throwable = throwable.getCause()) == null) continue;
            b2.append("<i>Caused by: </i>");
            lengthOfLastTrace = stack.length;
        }
        b2.append("</html>");
        return b2.toString();
    }

    private static String reportThrowable(Throwable throwable, String submissionURL) throws IOException {
        URL url = new URL(submissionURL);
        URLConnection c2 = url.openConnection();
        c2.setDoOutput(true);
        c2.setDoInput(true);
        c2.addRequestProperty("Content-type", "application/x-java-serialized-object");
        if (c2 instanceof HttpURLConnection) {
            ((HttpURLConnection)c2).setRequestMethod("POST");
        }
        c2.connect();
        ObjectOutputStream out = new ObjectOutputStream(c2.getOutputStream());
        out.writeObject(throwable);
        out.close();
        Object response = c2.getContent();
        StringBuffer message = new StringBuffer();
        if (response instanceof InputStream) {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)response));
            while ((line = in.readLine()) != null) {
                message.append(line);
            }
        }
        return message.toString();
    }

    private int showOptionDialog(final int type, final String title, final String message, final int optionType, final List<Object> opts, final Object initialValue) {
        int selected;
        if (SwingUtilities.isEventDispatchThread()) {
            selected = JOptionPane.showOptionDialog(this.parent, message, title, optionType, type, null, opts.toArray(), initialValue);
        } else {
            final int[] handle = new int[1];
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        handle[0] = JOptionPane.showOptionDialog(GUIPrompt.this.parent, message, title, optionType, type, null, opts.toArray(), initialValue);
                    }
                });
            }
            catch (Throwable exception) {
                throw new IllegalStateException(exception);
            }
            selected = handle[0];
        }
        return selected;
    }

    private int showConfirmDialog(final int type, final String title, final String message, final int optionType) {
        int selected;
        if (SwingUtilities.isEventDispatchThread()) {
            selected = JOptionPane.showConfirmDialog(this.parent, message, title, optionType, type);
        } else {
            final int[] handle = new int[1];
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        handle[0] = JOptionPane.showConfirmDialog(GUIPrompt.this.parent, message, title, optionType, type);
                    }
                });
            }
            catch (Throwable exception) {
                throw new IllegalStateException(exception);
            }
            selected = handle[0];
        }
        return selected;
    }

    private Prompt.Option getSelected(Prompt.Options options, int selected) {
        Prompt.Option result;
        switch (selected) {
            case 0: {
                result = options == Prompt.Options.OK_CANCEL ? Prompt.Option.OK : Prompt.Option.YES;
                break;
            }
            case 1: {
                result = Prompt.Option.NO;
                break;
            }
            case 2: {
                result = Prompt.Option.CANCEL;
                break;
            }
            default: {
                result = options == Prompt.Options.YES_NO_CANCEL ? Prompt.Option.CANCEL : Prompt.Option.NO;
            }
        }
        return result;
    }

    private String wrapHtml(String string) {
        return "<html><body><div style='float:left; width:540px;'>" + string + "</div></body></html>";
    }

    public static class Test {
        public static void main(String[] args) {
            UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
            UIManager.put(GUIPrompt.CLOSE_BUTTON, "Close");
            UIManager.put(GUIPrompt.SHOW_DETAILS_BUTTON, "Show Details");
            UIManager.put(GUIPrompt.HIDE_DETAILS_BUTTON, "Hide Details");
            UIManager.put(GUIPrompt.COPY_BUTTON, "Copy");
            UIManager.put(GUIPrompt.SEND_REPORT_BUTTON, "Send Report");
            String url = args.length > 0 ? args[0] : null;
            try {
                Test.foo();
            }
            catch (Throwable e2) {
                new GUIPrompt().showMessageDialog(0, "Fatal Error", "A critical error occured", url, e2);
                System.exit(1);
            }
        }

        public static void foo() {
            Test.bar(null);
        }

        public static void bar(Object o2) {
            try {
                Test.blah(o2);
            }
            catch (NullPointerException e2) {
                throw (IllegalArgumentException)new IllegalArgumentException("null argument").initCause(e2);
            }
        }

        public static void blah(Object o2) {
            Class<?> c2 = o2.getClass();
        }
    }
}

