/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.variable;

import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.core.substitutor.VariableSubstitutorImpl;
import com.izforge.izpack.core.variable.ValueImpl;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.OsVersion;
import java.io.Serializable;
import java.util.Set;

public class ExecValue
extends ValueImpl
implements Serializable {
    private static final long serialVersionUID = -6438593229737421526L;
    private String[] cmd;
    private String dir;
    private boolean useStdErr = true;

    public ExecValue(String[] command, String dir, boolean isShellCommand, boolean useStdErr) {
        if (isShellCommand) {
            if (OsVersion.IS_WINDOWS) {
                this.cmd = new String[command.length + 2];
                this.cmd[0] = "cmd";
                this.cmd[1] = "/C";
                for (int i2 = 2; i2 < this.cmd.length; ++i2) {
                    this.cmd[i2] = command[i2 - 2];
                }
            } else if (OsVersion.IS_UNIX) {
                this.cmd = new String[command.length + 1];
                this.cmd[0] = "sh";
                for (int i3 = 1; i3 < this.cmd.length; ++i3) {
                    this.cmd[i3] = command[i3 - 1];
                }
            } else {
                this.cmd = command;
            }
        } else {
            this.cmd = command;
        }
        this.dir = dir;
        this.useStdErr = useStdErr;
    }

    public String[] getCmd() {
        return this.cmd;
    }

    public void setCmd(String[] cmd) {
        this.cmd = cmd;
    }

    @Override
    public void validate() throws Exception {
        if (this.cmd == null || this.cmd.length <= 0) {
            throw new IllegalArgumentException("Bad command line");
        }
    }

    @Override
    public String resolve() {
        VariableSubstitutorImpl substitutor = new VariableSubstitutorImpl(this.getInstallData().getVariables());
        return this.resolve(substitutor);
    }

    @Override
    public String resolve(VariableSubstitutor ... substitutors) {
        String _dir_ = null;
        String[] _cmd_ = new String[this.cmd.length];
        for (VariableSubstitutor substitutor : substitutors) {
            _dir_ = substitutor.substitute(this.dir, null);
        }
        for (int i2 = 0; i2 < this.cmd.length; ++i2) {
            String _cmdarg_ = this.cmd[i2];
            for (VariableSubstitutor substitutor : substitutors) {
                _cmdarg_ = substitutor.substitute(_cmdarg_, null);
            }
            _cmd_[i2] = _cmdarg_;
        }
        String[] execOut = new String[2];
        int ret = new FileExecutor().executeCommand(_cmd_, execOut, _dir_);
        if (ret == 0) {
            if (this.useStdErr) {
                return execOut[1];
            }
            return execOut[0];
        }
        return null;
    }

    @Override
    public Set<String> getVarRefs() {
        Set<String> unresolvedNames = ExecValue.parseUnresolvedVariableNames(this.cmd);
        unresolvedNames.addAll(ExecValue.parseUnresolvedVariableNames(this.dir));
        return unresolvedNames;
    }
}

