/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.rules.process;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.rules.Condition;
import java.util.HashSet;
import java.util.Set;

public class VariableCondition
extends Condition {
    private static final long serialVersionUID = 2153074626635361048L;
    protected String variablename;
    protected String value;

    public VariableCondition() {
        this(null, null);
    }

    public VariableCondition(String name, String value) {
        this.variablename = name;
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getVariablename() {
        return this.variablename;
    }

    public void setVariablename(String variablename) {
        this.variablename = variablename;
    }

    @Override
    public void readFromXML(IXMLElement xmlcondition) throws Exception {
        try {
            this.variablename = xmlcondition.getFirstChildNamed("name").getContent();
            this.value = xmlcondition.getFirstChildNamed("value").getContent();
        }
        catch (Exception e2) {
            throw new Exception("Missing attribute in condition \"" + this.getId() + "\"");
        }
    }

    @Override
    public boolean isTrue() {
        InstallData installData = this.getInstallData();
        if (installData != null) {
            String val = installData.getVariable(this.variablename);
            if (val == null) {
                return false;
            }
            Variables variables = installData.getVariables();
            return variables.replace(val).equals(variables.replace(this.value));
        }
        return false;
    }

    @Override
    public String getDependenciesDetails() {
        StringBuffer details = new StringBuffer();
        details.append(this.getId());
        details.append(" depends on a value of <b>");
        details.append(this.value);
        details.append("</b> on variable <b>");
        details.append(this.variablename);
        details.append(" (current value: ");
        details.append(this.getInstallData().getVariable(this.variablename));
        details.append(")");
        details.append("</b><br/>");
        return details.toString();
    }

    @Override
    public void makeXMLData(IXMLElement conditionRoot) {
        XMLElementImpl nameEl = new XMLElementImpl("name", conditionRoot);
        nameEl.setContent(this.variablename);
        conditionRoot.addChild(nameEl);
        XMLElementImpl valueEl = new XMLElementImpl("value", conditionRoot);
        valueEl.setContent(this.value);
        conditionRoot.addChild(valueEl);
    }

    @Override
    public Set<String> getVarRefs() {
        HashSet<String> vars = new HashSet<String>(2);
        vars.add(this.variablename);
        return vars;
    }
}

