/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.rules.process;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.api.rules.Condition;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaCondition
extends Condition {
    private static final long serialVersionUID = 2019261646805005092L;
    private static final transient Logger logger = Logger.getLogger(JavaCondition.class.getName());
    protected String classname;
    protected String methodname;
    protected String fieldname;
    protected boolean complete;
    protected String returnvalue;
    protected String returnvaluetype;
    private transient Class<?> usedclass;
    private transient Field usedfield;
    private transient Method usedmethod;

    public JavaCondition() {
    }

    public JavaCondition(String classname, String fieldname, boolean complete, String returnvalue, String returnvaluetype) {
        this.classname = classname;
        this.fieldname = fieldname;
        this.complete = complete;
        this.returnvalue = returnvalue;
        this.returnvaluetype = returnvaluetype;
    }

    @Override
    public boolean isTrue() {
        if (!this.complete) {
            return false;
        }
        if (this.usedclass == null) {
            try {
                this.usedclass = Class.forName(this.classname);
            }
            catch (ClassNotFoundException e2) {
                logger.warning("Can't find class " + this.classname);
                return false;
            }
        }
        if (this.usedfield == null && this.fieldname != null) {
            try {
                this.usedfield = this.usedclass.getField(this.fieldname);
            }
            catch (SecurityException e3) {
                logger.warning("No permission to access specified field: " + this.fieldname);
                return false;
            }
            catch (NoSuchFieldException e4) {
                logger.warning("No such field: " + this.fieldname);
                return false;
            }
        }
        if (this.usedmethod == null && this.methodname != null) {
            try {
                this.usedmethod = this.usedclass.getMethod(this.methodname, new Class[0]);
            }
            catch (SecurityException e5) {
                logger.warning("No permission to access specified method: " + this.methodname);
                return false;
            }
            catch (NoSuchMethodException e6) {
                logger.warning("No such method: " + this.methodname);
                return false;
            }
        }
        if (this.usedfield != null) {
            try {
                Object value = this.usedfield.get(null);
                logger.log(Level.FINE, this.fieldname + ":  value: " + value);
                return this.checkValue(value);
            }
            catch (IllegalArgumentException e7) {
                logger.log(Level.WARNING, this.fieldname + ": " + e7.getMessage(), e7);
            }
            catch (IllegalAccessException e8) {
                logger.log(Level.WARNING, this.fieldname + ": " + e8.getMessage(), e8);
            }
        }
        if (this.usedmethod != null) {
            try {
                Object value = this.usedmethod.invoke(null, new Object[0]);
                logger.log(Level.FINE, this.methodname + ":  value: " + value);
                return this.checkValue(value);
            }
            catch (IllegalArgumentException e9) {
                logger.log(Level.WARNING, this.methodname + ": " + e9.getMessage(), e9);
            }
            catch (IllegalAccessException e10) {
                logger.log(Level.WARNING, this.methodname + ": " + e10.getMessage(), e10);
            }
            catch (InvocationTargetException e11) {
                logger.log(Level.WARNING, this.methodname + ": " + e11.getMessage(), e11.getTargetException());
            }
        }
        return false;
    }

    private boolean checkValue(Object returnval) {
        if ("boolean".equals(this.returnvaluetype)) {
            return Boolean.valueOf(this.returnvalue).equals(returnval);
        }
        if ("string".equals(this.returnvaluetype)) {
            return String.valueOf(this.returnvalue).equals(returnval);
        }
        logger.warning("Return type '" + this.returnvalue + "' not supported");
        return false;
    }

    @Override
    public void readFromXML(IXMLElement xmlcondition) throws Exception {
        IXMLElement fieldel;
        if (xmlcondition.getChildrenCount() != 2) {
            throw new Exception("Condition of type java needs (java,returnvalue)");
        }
        IXMLElement javael = xmlcondition.getFirstChildNamed("java");
        IXMLElement classel = javael.getFirstChildNamed("class");
        if (classel == null) {
            throw new Exception("Java-Element needs (class,method?,field?)");
        }
        this.classname = classel.getContent();
        IXMLElement methodel = javael.getFirstChildNamed("method");
        if (methodel != null) {
            this.methodname = methodel.getContent();
        }
        if ((fieldel = javael.getFirstChildNamed("field")) != null) {
            this.fieldname = fieldel.getContent();
        }
        if (this.methodname == null && this.fieldname == null) {
            throw new Exception("java element needs (class, method?,field?)");
        }
        IXMLElement returnvalel = xmlcondition.getFirstChildNamed("returnvalue");
        if (returnvalel == null) {
            throw new Exception("Missing \"returnvalue\" element");
        }
        this.returnvalue = returnvalel.getContent();
        this.returnvaluetype = returnvalel.getAttribute("type");
        this.complete = true;
    }

    @Override
    public void makeXMLData(IXMLElement conditionRoot) {
        XMLElementImpl javael = new XMLElementImpl("java", conditionRoot);
        conditionRoot.addChild(javael);
        XMLElementImpl classel = new XMLElementImpl("class", javael);
        classel.setContent(this.classname);
        javael.addChild(classel);
        if (this.methodname != null) {
            XMLElementImpl methodel = new XMLElementImpl("method", javael);
            methodel.setContent(this.methodname);
            javael.addChild(methodel);
        }
        if (this.fieldname != null) {
            XMLElementImpl fieldel = new XMLElementImpl("field", javael);
            fieldel.setContent(this.fieldname);
            javael.addChild(fieldel);
        }
        XMLElementImpl returnvalel = new XMLElementImpl("returnvalue", javael);
        returnvalel.setContent(this.returnvalue);
        returnvalel.setAttribute("type", this.returnvaluetype);
        javael.addChild(returnvalel);
    }

    @Override
    public String getDependenciesDetails() {
        StringBuffer details = new StringBuffer();
        details.append(this.getId());
        details.append(" depends on the ");
        if (this.fieldname != null) {
            details.append("value of field <b>");
            details.append(this.fieldname);
            details.append("</b>");
        } else {
            details.append("return value of method <b>");
            details.append(this.methodname);
            details.append("</b>");
        }
        details.append(" on an instance of class <b>");
        details.append(this.classname);
        details.append("</b> which should be <b>");
        details.append(this.returnvalue);
        details.append("</b><br/>");
        return details.toString();
    }

    @Override
    public Set<String> getVarRefs() {
        return new HashSet<String>(1);
    }
}

