/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.io;

import com.izforge.izpack.core.io.ByteCountingOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;

public class FileSpanningOutputStream
extends OutputStream {
    public static final long KB = 1000L;
    public static final long MB = 1000000L;
    public static final long DEFAULT_VOLUME_SIZE = 650000000L;
    protected static final int MAGIC_NUMBER_LENGTH = 10;
    private static final int MIN_VOLUME_SIZE = 11;
    private SpanningOutputStream spanningOutputStream;
    private GZIPOutputStream gzipOutputStream;
    private long filePointer;
    private static final Logger logger = Logger.getLogger(FileSpanningOutputStream.class.getName());

    public FileSpanningOutputStream(String volumePath, long maxFirstVolumeSize, long maxVolumeSize) throws IOException {
        this(new File(volumePath), maxFirstVolumeSize, maxVolumeSize);
    }

    public FileSpanningOutputStream(File volume, long maxVolumeSize) throws IOException {
        this(volume, maxVolumeSize, maxVolumeSize);
    }

    public FileSpanningOutputStream(File volume, long maxFirstVolumeSize, long maxVolumeSize) throws IOException {
        this.spanningOutputStream = new SpanningOutputStream(volume, maxFirstVolumeSize, maxVolumeSize);
        this.gzipOutputStream = new GZIPOutputStream(this.spanningOutputStream);
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.gzipOutputStream.close();
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        this.gzipOutputStream.write(b2, off, len);
        this.filePointer += (long)len;
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    @Override
    public void write(int b2) throws IOException {
        this.gzipOutputStream.write(b2);
        ++this.filePointer;
    }

    @Override
    public void flush() throws IOException {
        this.gzipOutputStream.flush();
    }

    public int getVolumes() {
        return this.spanningOutputStream.getVolumes();
    }

    public long getFilePointer() {
        return this.filePointer;
    }

    static String formatMagic(byte[] magic) {
        StringBuilder builder = new StringBuilder();
        for (byte b2 : magic) {
            if (builder.length() != 0) {
                builder.append(' ');
            }
            builder.append(Integer.toHexString(b2 & 0xFF));
        }
        return builder.toString();
    }

    private static class SpanningOutputStream
    extends ByteCountingOutputStream {
        private final long maxVolumeSize;
        private int index;
        private String basePath;
        private byte[] magic;
        private final long maxFirstVolumeSize;

        public SpanningOutputStream(File volume, long maxFirstVolumeSize, long maxVolumeSize) throws IOException {
            super(new FileOutputStream(volume));
            if (maxVolumeSize < 11L) {
                throw new IllegalArgumentException("Argument 'maxVolumeSize' is invalid: " + maxVolumeSize);
            }
            if (maxFirstVolumeSize < 11L) {
                throw new IllegalArgumentException("Argument 'maxFirstVolumeSize' is invalid: " + maxFirstVolumeSize);
            }
            this.basePath = volume.getAbsolutePath();
            this.maxVolumeSize = maxVolumeSize;
            this.maxFirstVolumeSize = maxFirstVolumeSize;
            this.magic = this.generateMagicNumber();
            this.initVolume();
        }

        @Override
        public void write(byte[] b2, int off, int len) throws IOException {
            long available = this.getAvailable();
            if (available < (long)len) {
                logger.fine("Not enough space left on volume. (available: " + available + ")");
                if (available > 0L) {
                    super.write(b2, off, (int)available);
                    off = (int)((long)off + available);
                    len = (int)((long)len - available);
                }
                this.createNextVolume();
                this.write(b2, off, len);
            } else {
                super.write(b2, off, len);
            }
        }

        @Override
        public void write(int b2) throws IOException {
            long available = this.getAvailable();
            if (available == 0L) {
                this.createNextVolume();
            }
            super.write(b2);
        }

        private void createNextVolume() throws IOException {
            this.close();
            ++this.index;
            String name = this.basePath + "." + this.index;
            this.setOutputStream(new FileOutputStream(name));
            this.initVolume();
        }

        public int getVolumes() {
            return this.index + 1;
        }

        private void initVolume() throws IOException {
            this.write(this.magic);
        }

        private long getAvailable() {
            long count = this.getByteCount();
            return this.index == 0 ? this.maxFirstVolumeSize - count : this.maxVolumeSize - count;
        }

        private byte[] generateMagicNumber() {
            byte[] result = new byte[10];
            Random random = new Random();
            random.nextBytes(result);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Created new magic number for SpanningOutputStream: " + FileSpanningOutputStream.formatMagic(this.magic));
            }
            return result;
        }
    }
}

