/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.api.handler;

import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.handler.Prompt;

public abstract class AbstractPrompt
implements Prompt {
    @Override
    public void message(Throwable throwable) {
        if (throwable instanceof IzPackException) {
            IzPackException ize = (IzPackException)throwable;
            switch (ize.getPromptType()) {
                case ERROR: {
                    this.error(throwable);
                    break;
                }
                case WARNING: {
                    this.warn(throwable);
                    break;
                }
                default: {
                    this.message(Prompt.Type.INFORMATION, throwable.getMessage());
                    break;
                }
            }
        } else {
            this.error(throwable);
        }
    }

    @Override
    public void message(Prompt.Type type, String message) {
        this.message(type, null, message);
    }

    @Override
    public void message(Prompt.Type type, String title, String message) {
        this.message(type, title, message, null);
    }

    @Override
    public void warn(Throwable throwable) {
        String message = AbstractPrompt.getThrowableMessage(throwable);
        this.warn(message != null ? message : "An error occured");
    }

    @Override
    public void warn(String message) {
        this.warn(null, message);
    }

    @Override
    public void warn(String title, String message) {
        this.message(Prompt.Type.WARNING, title, message, null);
    }

    @Override
    public void error(Throwable throwable) {
        String message = AbstractPrompt.getThrowableMessage(throwable);
        this.error(null, message != null ? message : "An error occured", throwable);
    }

    @Override
    public void error(String message) {
        this.error(null, message);
    }

    @Override
    public void error(String message, Throwable throwable) {
        this.error(null, message, throwable);
    }

    @Override
    public void error(String title, String message) {
        this.message(Prompt.Type.ERROR, title, message, null);
    }

    @Override
    public void error(String title, String message, Throwable throwable) {
        this.message(Prompt.Type.ERROR, title, message, throwable);
    }

    @Override
    public Prompt.Option confirm(Prompt.Type type, String message, Prompt.Options options) {
        return this.confirm(type, message, options, null);
    }

    @Override
    public Prompt.Option confirm(Prompt.Type type, String message, Prompt.Options options, Prompt.Option defaultOption) {
        return this.confirm(type, null, message, options, defaultOption);
    }

    @Override
    public Prompt.Option confirm(Prompt.Type type, String title, String message, Prompt.Options options) {
        return this.confirm(type, title, message, options, null);
    }

    protected String getTitle(Prompt.Type type) {
        String result;
        switch (type) {
            case INFORMATION: {
                result = "Info";
                break;
            }
            case QUESTION: {
                result = "Question";
                break;
            }
            case WARNING: {
                result = "Warning";
                break;
            }
            default: {
                result = "Error";
            }
        }
        return result;
    }

    public static String getThrowableMessage(Throwable throwable) {
        String message = null;
        while (throwable != null) {
            message = throwable.getMessage();
            throwable = throwable.getCause();
        }
        return message;
    }

    protected static String getDetails(Throwable throwable) {
        StringBuffer b2 = new StringBuffer();
        int lengthOfLastTrace = 1;
        while (throwable != null) {
            b2.append(throwable.getClass().getName() + ": " + throwable.getMessage());
            StackTraceElement[] stack = throwable.getStackTrace();
            for (int i2 = stack.length - lengthOfLastTrace; i2 >= 0; --i2) {
                b2.append("- in " + stack[i2].getClassName() + "." + stack[i2].getMethodName() + "() at " + stack[i2].getFileName() + ":" + stack[i2].getLineNumber() + "\n");
            }
            if ((throwable = throwable.getCause()) == null) continue;
            b2.append("Caused by: ");
            lengthOfLastTrace = stack.length;
        }
        return b2.toString();
    }
}

