/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.api.config.spi;

import com.izforge.izpack.api.config.spi.AbstractBeanInvocationHandler;
import com.izforge.izpack.api.config.spi.BeanAccess;
import com.izforge.izpack.api.config.spi.ServiceFinder;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URL;
import java.util.TimeZone;

public class BeanTool {
    private static final String PARSE_METHOD = "valueOf";
    private static final BeanTool INSTANCE = ServiceFinder.findService(BeanTool.class);

    public static final BeanTool getInstance() {
        return INSTANCE;
    }

    public void inject(Object bean, BeanAccess props) {
        for (PropertyDescriptor pd : this.getPropertyDescriptors(bean.getClass())) {
            try {
                Object value;
                Method method = pd.getWriteMethod();
                String name = pd.getName();
                if (method == null || props.propLength(name) == 0) continue;
                if (pd.getPropertyType().isArray()) {
                    value = Array.newInstance(pd.getPropertyType().getComponentType(), props.propLength(name));
                    for (int i2 = 0; i2 < props.propLength(name); ++i2) {
                        Array.set(value, i2, this.parse(props.propGet(name, i2), pd.getPropertyType().getComponentType()));
                    }
                } else {
                    value = this.parse(props.propGet(name), pd.getPropertyType());
                }
                method.invoke(bean, value);
            }
            catch (Exception x2) {
                throw (IllegalArgumentException)new IllegalArgumentException("Failed to set property: " + pd.getDisplayName()).initCause(x2);
            }
        }
    }

    public void inject(BeanAccess props, Object bean) {
        for (PropertyDescriptor pd : this.getPropertyDescriptors(bean.getClass())) {
            try {
                Object value;
                Method method = pd.getReadMethod();
                if (method == null || "class".equals(pd.getName()) || (value = method.invoke(bean, (Object[])null)) == null) continue;
                if (pd.getPropertyType().isArray()) {
                    for (int i2 = 0; i2 < Array.getLength(value); ++i2) {
                        Object v2 = Array.get(value, i2);
                        if (v2 != null && !v2.getClass().equals(String.class)) {
                            v2 = v2.toString();
                        }
                        props.propAdd(pd.getName(), (String)v2);
                    }
                    continue;
                }
                props.propSet(pd.getName(), value.toString());
            }
            catch (Exception x2) {
                throw new IllegalArgumentException("Failed to set property: " + pd.getDisplayName(), x2);
            }
        }
    }

    public <T> T parse(String value, Class<T> clazz) throws IllegalArgumentException {
        if (clazz == null) {
            throw new IllegalArgumentException("null argument");
        }
        Object o2 = null;
        o2 = value == null ? (Object)this.zero(clazz) : (clazz.isPrimitive() ? this.parsePrimitiveValue(value, clazz) : (clazz == String.class ? value : (clazz == Character.class ? new Character(value.charAt(0)) : this.parseSpecialValue(value, clazz))));
        return (T)o2;
    }

    public <T> T proxy(Class<T> clazz, BeanAccess props) {
        return clazz.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, (InvocationHandler)new BeanInvocationHandler(props)));
    }

    public <T> T zero(Class<T> clazz) {
        Comparable<Boolean> o2 = null;
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                o2 = Boolean.FALSE;
            } else if (clazz == Byte.TYPE) {
                o2 = (byte)0;
            } else if (clazz == Character.TYPE) {
                o2 = new Character('\u0000');
            } else if (clazz == Double.TYPE) {
                o2 = new Double(0.0);
            } else if (clazz == Float.TYPE) {
                o2 = new Float(0.0f);
            } else if (clazz == Integer.TYPE) {
                o2 = 0;
            } else if (clazz == Long.TYPE) {
                o2 = 0L;
            } else if (clazz == Short.TYPE) {
                o2 = (short)0;
            }
        }
        return (T)o2;
    }

    protected <T> Object parseSpecialValue(String value, Class<T> clazz) throws IllegalArgumentException {
        Object o2;
        try {
            if (clazz == File.class) {
                o2 = new File(value);
            } else if (clazz == URL.class) {
                o2 = new URL(value);
            } else if (clazz == URI.class) {
                o2 = new URI(value);
            } else if (clazz == Class.class) {
                o2 = Class.forName(value);
            } else if (clazz == TimeZone.class) {
                o2 = TimeZone.getTimeZone(value);
            } else {
                Method parser = clazz.getMethod(PARSE_METHOD, String.class);
                o2 = parser.invoke(null, value);
            }
        }
        catch (Exception x2) {
            throw (IllegalArgumentException)new IllegalArgumentException().initCause(x2);
        }
        return o2;
    }

    private <T> PropertyDescriptor[] getPropertyDescriptors(Class<T> clazz) {
        try {
            return Introspector.getBeanInfo(clazz).getPropertyDescriptors();
        }
        catch (IntrospectionException x2) {
            throw new IllegalArgumentException(x2);
        }
    }

    private <T> Object parsePrimitiveValue(String value, Class<T> clazz) throws IllegalArgumentException {
        Comparable<Boolean> o2 = null;
        try {
            if (clazz == Boolean.TYPE) {
                o2 = Boolean.valueOf(value);
            } else if (clazz == Byte.TYPE) {
                o2 = Byte.valueOf(value);
            } else if (clazz == Character.TYPE) {
                o2 = new Character(value.charAt(0));
            } else if (clazz == Double.TYPE) {
                o2 = Double.valueOf(value);
            } else if (clazz == Float.TYPE) {
                o2 = Float.valueOf(value);
            } else if (clazz == Integer.TYPE) {
                o2 = Integer.valueOf(value);
            } else if (clazz == Long.TYPE) {
                o2 = Long.valueOf(value);
            } else if (clazz == Short.TYPE) {
                o2 = Short.valueOf(value);
            }
        }
        catch (Exception x2) {
            throw (IllegalArgumentException)new IllegalArgumentException().initCause(x2);
        }
        return o2;
    }

    static class BeanInvocationHandler
    extends AbstractBeanInvocationHandler {
        private final BeanAccess _backend;

        BeanInvocationHandler(BeanAccess backend) {
            this._backend = backend;
        }

        @Override
        protected Object getPropertySpi(String property, Class<?> clazz) {
            String[] ret = null;
            if (clazz.isArray()) {
                int length = this._backend.propLength(property);
                if (length != 0) {
                    String[] all = new String[length];
                    for (int i2 = 0; i2 < all.length; ++i2) {
                        all[i2] = this._backend.propGet(property, i2);
                    }
                    ret = all;
                }
            } else {
                ret = this._backend.propGet(property);
            }
            return ret;
        }

        @Override
        protected void setPropertySpi(String property, Object value, Class<?> clazz) {
            if (clazz.isArray()) {
                this._backend.propDel(property);
                for (int i2 = 0; i2 < Array.getLength(value); ++i2) {
                    this._backend.propAdd(property, Array.get(value, i2).toString());
                }
            } else {
                this._backend.propSet(property, value.toString());
            }
        }

        @Override
        protected boolean hasPropertySpi(String property) {
            return this._backend.propLength(property) != 0;
        }
    }
}

