CREATE TABLE ld_importfolder (ld_id bigint not null, ld_lastmodified timestamp not null, ld_creation timestamp not null, ld_recordversion bigint not null,
                              ld_deleted int NOT NULL, ld_tenantid bigint NOT NULL, ld_path varchar(4000), ld_provider varchar(255), ld_host varchar(255), 
                              ld_port varchar(10), ld_domain varchar(255), ld_username varchar(255), ld_password varchar(255), ld_targetfolderid bigint, 
                              ld_includes varchar(255), ld_excludes varchar(255), ld_maxsize int, ld_tags varchar(4000), ld_language varchar(10), 
                              ld_depth int NOT NULL, ld_enabled int, ld_templateId bigint, ld_ocrTemplateId bigint, ld_barcodeTemplateId bigint, 
                              ld_delimport int, ld_importempty int, ld_startdate timestamp null, ld_updatepolicy int, ld_inheritrights int, 
                              ld_recordhistory int not null, ld_preventduplications int not null, ld_batch bigint not NULL, ld_automation varchar(4000), 
                              ld_automationafter varchar(4000), ld_automationend varchar(4000), PRIMARY KEY(ld_id)
);

create table ld_importfolder_history (ld_id bigint not null, ld_lastmodified timestamp not null, ld_creation timestamp not null, ld_recordversion bigint not null, 
                                      ld_deleted int not null, ld_tenantid bigint not null, ld_date timestamp, ld_event varchar(255), ld_revision varchar(255),
                                      ld_comment varchar(4000), ld_docid bigint, ld_folderid bigint, ld_filename varchar(255), 
                                      ld_filesize bigint, ld_path varchar(4000), ld_pathold varchar(4000), ld_filenameold varchar(255),
                                      ld_color varchar(255), ld_importfolderid bigint not null, ld_sessionid varchar(255), ld_ip varchar(255),
                                      ld_userid bigint, ld_username varchar(255), ld_userlogin varchar(255), ld_reason varchar(4000), ld_device varchar(255),
                                      ld_geolocation varchar(255), ld_keylabel varchar(255), ld_notified int not null, ld_fileversion varchar(10), ld_version varchar(10), primary key (ld_id));

create sequence ld_importfolder_SEQ start with 100 INCREMENT BY 50;
create sequence ld_importfolder_history_SEQ start with 100 INCREMENT BY 50;

alter table ld_importfolder add constraint FK_IMPFOLDER_TARGET foreign key (ld_targetfolderid) references ld_folder(ld_id);

insert into ld_menu   
		   (ld_id,ld_lastmodified,ld_creation,ld_deleted,ld_name,ld_parentid,ld_icon,ld_type,ld_tenantid,ld_recordversion,ld_position,ld_enabled)
values     (-1000,CURRENT_TIMESTAMP,CURRENT_TIMESTAMP,0,'importfolders',8,'folder_network.png',1,1,1,1,1);

INSERT INTO ld_menu_acl VALUES(-1000,1,1,1);

insert into ld_user
           (ld_id,ld_lastmodified,ld_creation,ld_deleted,ld_enabled,ld_username,ld_password,ld_name,ld_firstname,ld_street,ld_postalcode,ld_city,ld_country,ld_language,ld_email,ld_telephone,ld_type,ld_passwordchanged,ld_passwordexpires,ld_source,ld_quota,ld_passwordexpired,ld_tenantid,ld_recordversion,ld_enforcewrktime,ld_evalform,ld_legals)
values     (-1000,CURRENT_TIMESTAMP,CURRENT_TIMESTAMP,0,1,'_importfolder','','Importer','Folder','','','','','en','importfolder@acme.com','',1,null,0,0,-1,0,1,1,0,0,0);
insert into ld_group(ld_id,ld_lastmodified,ld_creation,ld_deleted,ld_name,ld_description,ld_type,ld_tenantid,ld_recordversion)
values     (-1000,CURRENT_TIMESTAMP,CURRENT_TIMESTAMP,0,'_user_-1000','',1,1,1);
insert into ld_usergroup
values (-1000,-1000);