create table ld_archive (ld_id bigint not null, ld_lastmodified timestamp not null, ld_recordversion bigint not null, 
                         ld_deleted int not null, ld_tenantid bigint not null, ld_name varchar(255) not null, 
                         ld_description varchar(255), ld_status int not null, ld_creation timestamp not null, 
                         ld_size bigint not null, ld_type int not null, ld_creatorid bigint not null, 
                         ld_creatorname varchar(255), ld_closerid bigint, ld_closername varchar(255), 
                         ld_closure timestamp, ld_mode int not null, ld_importtemplate int not null, 
                         ld_importcustomid int not null, primary key (ld_id));
create table ld_archive_entry (ld_archiveid bigint not null, ld_versionid bigint not null, primary key (ld_archiveid, ld_versionid));

create sequence ld_archive_SEQ start with 100 INCREMENT BY 50;

alter table ld_archive_entry add constraint FK83962C74DB63F37 foreign key (ld_archiveid) references ld_archive(ld_id) on delete cascade;
alter table ld_archive_entry add constraint FK83962C748A053CE foreign key (ld_versionid) references ld_version(ld_id) on delete cascade; 

create unique index AK_ARCHIVE on ld_archive (ld_tenantid,ld_name,ld_mode);

insert into ld_menu
           (ld_id,ld_lastmodified,ld_creation,ld_deleted,ld_name,ld_parentid,ld_icon,ld_type,ld_tenantid,ld_recordversion,ld_position,ld_enabled)
values     (-2030,CURRENT_TIMESTAMP,CURRENT_TIMESTAMP,0,'importarchives',8,'impexIn.png',1,1,1,1,1);

insert into ld_menu
           (ld_id,ld_lastmodified,ld_creation,ld_deleted,ld_name,ld_parentid,ld_icon,ld_type,ld_tenantid,ld_recordversion,ld_position,ld_enabled)
values     (-2040,CURRENT_TIMESTAMP,CURRENT_TIMESTAMP,0,'exportarchives',8,'impexOut.png',1,1,1,1,1);

insert into ld_menu_acl(ld_menuid, ld_groupid, ld_read, ld_write) values (-2030,1,1,1);
insert into ld_menu_acl(ld_menuid, ld_groupid, ld_read, ld_write) values (-2040,1,1,1);

insert into ld_user
           (ld_id,ld_lastmodified,ld_creation,ld_deleted,ld_enabled,ld_username,ld_password,ld_name,ld_firstname,ld_street,ld_postalcode,ld_city,ld_country,ld_language,ld_email,ld_telephone,ld_type,ld_passwordchanged,ld_passwordexpires,ld_source,ld_quota,ld_passwordexpired,ld_tenantid,ld_recordversion,ld_enforcewrktime,ld_evalform,ld_legals)
values     (-1100,CURRENT_TIMESTAMP,CURRENT_TIMESTAMP,0,1,'_impex','','impex','impex','','','','','en','impex@acme.com','',1,null,0,0,-1,0,1,1,0,0,0);
insert into ld_group
           (ld_id,ld_lastmodified,ld_creation,ld_deleted,ld_tenantid,ld_name,ld_type,ld_recordversion)
values     (-1100,CURRENT_TIMESTAMP,CURRENT_TIMESTAMP,0,1,'_user_-1100',1,1);
insert into ld_usergroup
values (-1100,-1100);

insert into ld_messagetemplate (ld_id, ld_lastmodified, ld_creation, ld_deleted, ld_name, ld_type, ld_language, ld_subject, ld_body, ld_tenantid,ld_recordversion)
values(60, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP,0,'impex.arc','system','en',
'$product - #if($archive.status == 4)$I18N.get(''badarchive'')#else $I18N.get(''archivefinalized'')#end',
'#if( $archive.status == 4 )
$I18N.format(''archiveuncorrectmessage'',$archive.name)
#else
$I18N.format(''archivefinalizedmessage'',$archive.name)
#end',1,1);

insert into ld_messagetemplate (ld_id, ld_lastmodified, ld_creation, ld_deleted, ld_name, ld_type, ld_language, ld_subject, ld_body, ld_tenantid,ld_recordversion)
values(61, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP,0,'impex.inc','system','en',
'$product - $I18N.get(''archiveclosed'')', 
'$I18N.format(''archiveclosedmessage'',$archive.name)',1,1);
